function [out_scl,scl_frq,scl_time]=mk_tfrscalo(j,sr,low_freq,high_freq,time_step);
%[out_scl,scl_frq,scl_time]=mk_tfrscalo(j,sr,low_freq,high_freq,time_step);
%
%j numsamp x numstim
%sr = sampling ratei %default 1000
%default low_freq=2.5;   high_freq=50 hz.
%time step upon which TFR is evaluated  %default = 32msec
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<2
  sr=1000;
end
if nargin<3
   low_freq=2.5;
end
if nargin<4
   high_freq=50;
end
if nargin<5 
   time_step=32;
end

numpts_y=32;
[numsamp,numstim]=size(j);

time_step=(floor(time_step.*(sr./1000)));


wave=sqrt(numsamp); %half length of morlet wavelt   %0 mexican hat
numpts_x=length(1:time_step:numsamp);


fmin=low_freq./sr;
fmax=high_freq./sr;

out_scl=zeros(numpts_y,numpts_x,numstim);
for i=1:numstim
   in_j=j(:,i);
   h=hilbert(in_j);
   [out1,t,f]=tfrscalo(h,1:time_step:numsamp,wave,fmin,fmax,numpts_y);
   out_scl(:,:,i)=out1;
end

scl_frq=f.*sr;
scl_time=t./(sr./1000);

