function [t_out,p_out,mn1,mn2]=calc_tstat_scl(scl1,scl2,pair_samp);
%[t_out,p_out,mn1,mn2]=calc_tstat_scl(scl1,scl2,pair_samp);
%ttest scl1 > scl2
%pair_samp  use paired ttest; set to 1  default = 0;
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<3
   pair_samp=0;
end


[dim1,dim2,nmstm_1]=size(scl1);
[dim1,dim2,nmstm_2]=size(scl2);

t_out=zeros(dim1,dim2);
p_out=ones(dim1,dim2);

mn1=mean(scl1,3);
mn2=mean(scl2,3);
for i=1:dim1
   for j=1:dim2
      d1=scl1(i,j,:); 
      d2=scl2(i,j,:); 
      d1=reshape(d1,nmstm_1,1);
      d2=reshape(d2,nmstm_2,1);
      in1=d1;
      in2=d2;
      if pair_samp==1
         [t,p]=ttest_pair(d1,d2);
      else
         [h,p,ci,stats]=ttest2(d1,d2);
         t=stats.tstat;
      end   
      p_out(i,j)=p;
      t_out(i,j)=t;
   end
end
