function vb_BVMake2D3DTRF(TRFfn,T1fn,EPIfn,VMRdim)
% function vb_BVMake2D3DTRF(TRFfn,T1fn,EPIfn,VMRdim)
%
% coregister & make 2D-3D TRF file
% (this function dos not modify original mat files)
%
% TRFfn: TRF filename (*.trf)
%  T1fn: T1 3D filename (*.img)
%  EPIfn: EPI filename (*.img)
%  VMRdim(option): VMR dimension ([R-L, A-P, S-I]), default [256 256 256]
%
%
% 2002/12/19 N.Goda
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<3
  fprintf('\n invalid arguments\n');
  return
elseif nargin<4
  VMRdim=[256 256 256];
end

% preparation -------------------------------------------------------------
SWD=spm('Dir');
global sptl_Ornt;
if ~isempty(sptl_Ornt)
  tmpglobal=sptl_Ornt; % copy
  restoreglobal=1;
else
  restoreglobal=0;
end
sptl_Ornt = [0 0 0  0 0 0 -1 1 1 0 0 0]; % Radiological Convention (L is R)
DIR1 = [fullfile(SWD,'templates'),filesep];

% copy files
delete tmpt1* tmpepi*;
% Standard T1 3D
copyfile(T1fn,'tmpt1.img');
copyfile([T1fn(1:end-3) 'hdr'],'tmpt1.hdr');
T1F='tmpt1.img';
T1T=fullfile(DIR1,'T1.img');
% EPI
copyfile(EPIfn,'tmpepi.img');
copyfile([EPIfn(1:end-3) 'hdr'],'tmpepi.hdr');
EPIF='tmpepi.img';
EPIT=fullfile(DIR1,'EPI.img');

% read header info
% target (T1)
[T1dim T1vox]=spm_hread(T1F);
if ~isequal(T1vox,[1 1 1])
  fprintf('\n T1 3D should be 1mm^3 voxel\n');
  return
end
T1origin0=(T1dim(1:3)+1)/2; 
T1originmm0=T1vox.*T1origin0; % ex. [96 128.5 128.5] in mm
% object (EPI)
[EPIdim EPIvox]=spm_hread(EPIF);
EPIorigin0=(EPIdim(1:3)+1)/2; % dim64->32.5, % dim50->25.5 
EPIoriginmm0=EPIvox.*EPIorigin0;

% default BV center (maybe) [0-255], ex. [95,128,128] if VMRdim==[191,256,256]
BVcenter=round((VMRdim-1)/2);

% default BV center in SPM-voxel Coordinate in target space [1-256]
TGTV=BVvox2spmv(BVcenter,T1dim,VMRdim);   % ex. [96,128,128] if T1dim==[191,256,256] 
originmmoff=TGTV-T1originmm0; % origin offset in mm 

% set defalut mat file (adjust origin to BV origin) -------------------------
T1originmm1=T1originmm0+originmmoff;
off=-T1originmm1; % mm, origin adjusted
MT1=[T1vox(1) 0 0 off(1) ; 0 T1vox(2) 0 off(2) ; 0 0 T1vox(3) off(3) ; 0 0 0 1];
spm_get_space(T1F,MT1); % set default mat

% EPI
EPIoriginmm1=EPIoriginmm0+originmmoff;
off=-EPIoriginmm1; % mm, origin adjusted
M0=[EPIvox(1) 0 0 off(1) ; 0 EPIvox(2) 0 off(2) ; 0 0 EPIvox(3) off(3) ; 0 0 0 1];
spm_get_space(EPIF,M0); % set default mat

% coregister EPI -> T1 -----------------------------------------------------
% pre-coregitered OBJ center in SPM-voxel Coordinate in object space
OBJV0=inv(M0)*[0 0 0 1]'; 

% first step: default coregister (rough coregistration)
fprintf('\n first step coregistration ...');
spm_coregister(T1F, EPIF, T1T, EPIT, [],'n');
M1=spm_get_space(EPIF); % get coregistered mat

% second step: MI coregister
fprintf('\n MI coregistration ...');
x=spm_mireg(spm_vol(T1F), spm_vol(EPIF));
M2=inv(spm_matrix(x));

% final result
M3=M2*M1;
spm_get_space(EPIF, M3); %  overwrite by new mat

% convert to TRF -------------------------------------------------------------
% coregistered OBJ center in SPM-mm Coordinate
x1=M3*OBJV0;

% convert to SPM-voxel Coordinates in target space (1-256)
x2=inv(MT1)*x1;

% convert to BV-VMR Coordinates (0-255)
trf(1:3)=BVspmv2vox(x2(1:3)',T1dim,VMRdim);

% rotation
x=spm_imatrix(M3);
trf(4)=x(4)/pi*180;
trf(5)=-x(5)/pi*180;
trf(6)=-x(6)/pi*180;

% result output
fid(1)=1;
fid(2)=fopen(TRFfn,'w');
fprintf('\nTRF\n');
for i=1:2
  fprintf(fid(i),'\n');
  fprintf(fid(i),'y: %f\n',trf(2));
  fprintf(fid(i),'z: %f\n',trf(3));
  fprintf(fid(i),'x: %f\n',trf(1));
  fprintf(fid(i),'TraCor: %f\n',trf(4));
  fprintf(fid(i),'TraSag: %f\n',trf(5));
  fprintf(fid(i),'SagCor: %f\n',trf(6));
  fprintf(fid(i),'xFoV: %f\n',EPIdim(1)*EPIvox(1));
  fprintf(fid(i),'yFoV: %f\n',EPIdim(2)*EPIvox(2));
  fprintf(fid(i),'zFoV: %f\n',EPIdim(3)*EPIvox(3));
  fprintf(fid(i),'n_slices: %d\n',EPIdim(3));
  fprintf(fid(i),'sl_thick: %f\n',EPIvox(3));
  fprintf(fid(i),'sl_gap:   0.000000\n');
end
fclose(fid(2));

if restoreglobal
  sptl_Ornt=tmpglobal; 
end

return
