function	[Vhead,Vox] = spm_right_to_neuro_vox(Vspm,trans_info,Vdim,Vsize,nflag)
% Change Neuromag-Head coordinate to Right-hand SPM [m] coordinate
%  Point coordinate 
%  [Vhead,Vox] = spm_right_to_neuro_vox(Vspm,trans_info,Vdim,Vsize)
%  Normal vector
%  [Vhead,Vox] = spm_right_to_neuro_vox(Vspm,trans_info,Vdim,Vsize,1)
% ---- Input
% Vspm : NV x 3 right-handed SPM coordinate 
% Vdim  : Voxel dimension of Analize image
% Vsize : Voxel size of Analize image
% nflag = 0 : coordinate transformation (default)
%       = 1 : normal vector transformation
%           : no translation is applied
% ---- Output
% Vhead : NV x 3 Neuromag-Head coordinate
% Vox   : NV x 3 left-handed Voxcel coordinate 
%
% --- MRI-Voxel coordinate  (Image based)
%
% [Left-hand coordinate]
% X:Right(1) -> Left(256)   R->L
% Y:Front(1) -> Back(256)   A->P
% Z:Top(1)   -> Bottom(136) S->I
%
% --- SPM coordinate (Image based)
%
% [Right-hand coordinate]
% X: Left(-191/2)   -> Right(191/2) 
% Y: Back(-256/2)   -> Front(256/2)
% Z: Bottom(-256/2) -> Top(256/2) 
%
% --- Head coordinate
% X : from left to right : LPA -> RPA
% Y : from back to front : Nasion -> x-axis
% Z : from bottom to up.
%
% Masa-aki Sato 2009-4-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 4, error('Input argument error'); end
if nargin < 5, nflag = 0; end;

NV   = size(Vspm,1);
Vox  = zeros(NV,3);
% Change [m] to [mm]
Vspm = Vspm*1000;

if nflag == 1
	% SPM -> Voxcel
	Vox(:,1) = - Vspm(:,1)/Vsize(1);
	Vox(:,2) = - Vspm(:,2)/Vsize(2);
	Vox(:,3) = - Vspm(:,3)/Vsize(3);
	
	% Voxcel -> Head
	Vhead  = Vox * inv(trans_info.trans_head2vox(1:3,1:3));
	
	% normalization
	Vhead  = vb_repmultiply(Vhead , 1./sqrt(sum(Vhead.^2, 2)) );
	%Vox  = repmultiply(Vox , 1./sqrt(sum(Vox.^2, 2)) );
	% Vox coordinate is not physical coordinate and different scale axis
else
	% SPM -> Voxcel
	Vox(:,1) =  - Vspm(:,1) /Vsize(1) + Vdim(1)*0.5;
	Vox(:,2) =  - Vspm(:,2) /Vsize(2) + Vdim(2)*0.5;
	Vox(:,3) =  - Vspm(:,3) /Vsize(3) + Vdim(3)*0.5;
	
	% Voxcel -> Head
	Vhead  = [Vox ones(NV,1)] * inv(trans_info.trans_head2vox);
end

Vhead = Vhead(:,1:3);
