function	[Vspm, Vox] = neuro_head_to_spm_right(Vhead,trans_info,Vdim,nflag)
% Change Neuromag-Head coordinate to Right-hand SPM [m] coordinate
%  Point coordinate 
%  Vspm = neuro_head_to_spm_right(Vhead,trans_info,Vdim)
%  Normal vector
%  Vspm = neuro_head_to_spm_right(Vhead,trans_info,Vdim, 1)
% ---- Input
% Vhead : NV x 3 Neuromag-Head coordinate
% trans_info
%       .trans_head2vox : [4 x 4 double]
%                       : transformation matrix (HEAD(RAS) ==> Voxel)
%       .trans_vox2mri  : [4 x 4 double]
%                       : transformation matrix (VOXEL ==> MRI(RAS))
% Vdim  : Voxel dimension
% nflag = 0 : coordinate transformation (default)
%       = 1 : normal vector transformation
%           : no translation is applied
% ---- Output
% Vspm : NV x 3 right-handed SPM coordinate 
% Vox  : NV x 3 left-handed Voxel coordinate 
%
%
% --- SPM coordinate (RAS)
% X: Left(-191/2)   -> Right(191/2) 
% Y: Back(-256/2)   -> Front(256/2)
% Z: Bottom(-256/2) -> Top(256/2) 
%
% --- Head coordinate(RAS)
% X : from left to right
% Y : from back to front
% Z : from bottom to up
%
% Masa-aki Sato 2009-4-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3, error('Input argument error'); end
if nargin < 4, nflag = 0; end;

NV   = size(Vhead,1);
Vspm = zeros(NV,3);

% Get permutation matrix from rotation matrix
% trans_vox2mri : rotation + flip + scaling
% Rspm : transform matrix corresponding to axis permutation + flip + scaling
Rspm = get_transform_axis( trans_info.trans_vox2mri(1:3,1:3) );

if nflag == 1
	% Unit vector rotation
	% Head -> Voxel
	Vox  = Vhead * trans_info.trans_head2vox(1:3,1:3);
	
	% Voxel -> MRI/SPM
	Vspm = Vox * Rspm;
	
	% normalization
	Vspm = vb_repmultiply(Vspm, 1./sqrt(sum(Vspm.^2, 2)) );
	%Vox  = repmultiply(Vox , 1./sqrt(sum(Vox.^2, 2)) );
	% Vox coordinate is not physical coordinate and different scale axis
else
	% Head -> Voxel
	Vox  = [Vhead ones(NV,1)] * trans_info.trans_head2vox;
	
	% center origin
	Vspm(:,1) =  ( Vox(:,1) - Vdim(1)*0.5 );
	Vspm(:,2) =  ( Vox(:,2) - Vdim(2)*0.5 );
	Vspm(:,3) =  ( Vox(:,3) - Vdim(3)*0.5 );
	
	% MRI(RAS) [m] only differs origin with SPM-Right
	Vspm = Vspm * Rspm;

end

Vox = Vox(:,1:3);
