function	[pick,Qpick] = get_center_neuromag(ch_info)
% get neuromag sensor center position in head coordinate
%  [pick,Qpick,Weight] = get_center_neuromag(ch_info)
%
%    ch_info     @ channel information is including transform matrix
%             .Nch      [double]
%                 : The number of channels.
%             .channel_ix   [Nch x 1 double]
%                 : MEG channel name list.
%             .sensort_type [Nch x 1 double]
%                 : sensor type list
%             .coil_type    {Nch x 1 cell}
%                 : coil type string list
%                   ex. coil_type{1} = 'VV_PLANAR_T1'
%             .trans_coil2head   : {Nch x 1}
%                 : transformation matrix (COIL  ==> HEAD)
%                   trans_coil2head{n} = [4x4 double]
%             .trans_coil2device : {Nch x 1}
%                 : transformation matrix list (COIL  ==> DEVICE)
%                   trans_coil2device{n} = [4x4 double]
%             .trans_device2head : [4 x 4 double]
%                 : transformation matrix (DEVICE  ==> HEAD)
%
%  [rHead 1] = [rCoil 1] * ch_info.trans_coil2head{n}'
%
% Masa-aki Sato 2009-4-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nch = ch_info.Nch;

% Coil position & direction
pick  = zeros(Nch,3);
Qpick = zeros(Nch,3);

Ncoil = 0;
Nchan = 0;

% Head coordinate
for n=1:Nch
	% Transformation matrix from coil -> head
	U = ch_info.trans_coil2head{n}';
	
	% Get coil position & direction
	% fixed coil position is defined for coil_type in Coil coordinate
	[pick1, Qpick1] = sensor_center_neuromag(ch_info.coil_type{n}, U);
	
	Npick  = size(pick1,1);
	
	if Npick > 0,
		
		% Coil position & direction
		ix = (1:Npick) + Ncoil;
		pick(ix ,:)	= pick1;
		Qpick(ix ,:) = Qpick1;
		
		% Coil -> Channel matrix index
		% Channel index
		Nchan = Nchan + 1;
		Ncoil = Ncoil + Npick;
	end
end

pick  = pick(1:Ncoil,:) ;
Qpick = Qpick(1:Ncoil,:);
