function   img = change_img_orient_ras(img,R)
% change orientation of image to RAS coordinate
%   img = change_img_orient_ras(img,R)
% --- Input
% img : 3D image
% R : rotation matrix from current axis to RAS coordinate

% orient = get_orient_from_rot(R)
% --- orient
% orient : axis dim to get RAS coordinate
%        = [orient_x  orient_y  orient_z]
% orient_x : Left to Right axis dim of current image
% orient_y : Posterior to Anterior axis dim of current image
% orient_z : Inferior  to Superior  axis dim of current image
%
% Left to Right           1
% Posterior to Anterior   2
% Inferior to Superior    3
% Right to Left          -1
% Anterior to Posterior  -2
% Superior to Inferior   -3
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

orient = get_orient_from_rot(R);

% --- change axis of image
img = permute(img, abs(orient));

% orient = [3 1 2]
% img(j3,j1,j2) = img(j1,j2,j3)

dim = size(img);

% --- flip image
if orient(1) < 0
	img(1:dim(1),:,:) = img(dim(1):-1:1,:,:);
end
if orient(2) < 0
	img(:,1:dim(2),:) = img(:,dim(2):-1:1,:);
end
if orient(3) < 0
	img(:,:,1:dim(3)) = img(:,:,dim(3):-1:1);
end
