function [obj, result] = vb_mps_pointlist_add_point(obj, name, point)
% add point to mps_pointlist object.
% [USAGE]
%    [obj, result] = vb_mps_pointlist_add_point(<obj>, <name>, <point>);
% [IN]
%       obj : mps_pointlist object
%      name : point name(char)
%     point : imgXYZ
% [OUT]
%       obj : mps_pointlist object
%    result : true or false(when name was overlappped.)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('obj', 'var'), error('obj is need parmeter'); end
if ~exist('name', 'var'), error('name is need parameter'); end
if ~exist('point', 'var'), error('point is need parameter'); end

result = false;

if ~ischar(name)
    warning('name is not char.');
    name = char(name);
end

%
% name overlapping check
%
if ~isempty(strmatch(name, obj.name_list, 'exact'))
    return;
end

%
% --- Add new point to mps_pointlist object
%
obj.name_list{length(obj.name_list) + 1} = name;
obj.point_list{length(obj.point_list) + 1} = point;

result = true;
