function [obj] = vb_mask_image_element_new(name, coord_type, B, step)
% constructor of mask_image_element
% [USAGE]
%    [obj] = vb_mask_image_element_new(<name>, <coord_type>, <B>, <step>);
% [IN]
%          name : <<char array>> name of mask_image_element
%    coord_type : coordinate type of mask_image_data
%             B : mask image data
%          step : voxel size[mm]
% [OUT]
%    obj : mask_image_element
% [See]
%    relative function : vb_display_element_new
% Author: rhayashi
% Created: 2007-07-17
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('name', 'var'), error('name is a required parameter.'); end
if ~exist('coord_type', 'var')
    error('coord_type is a required parameter.');
end
if ~exist('B', 'var'), error('B is a required parameter.'); end
if ~exist('step', 'var'), error('step is a required parameter.'); end

%
% --- Main Procedure
%

% Inherit display_element class
obj = vb_display_element_new(name, coord_type);

% mask_image_element members
obj.class_name = 'mask_image_element';
obj.B = B;
obj.step = step;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end

