function [dim,vox,origin] = analyze_hdr_read(imagefile)
% Read Analyze/Nifti format header 
%   [dim,vox,origin] = analyze_hdr_read(imagefile)
%
% imagefile - filename 
% 
% --- Output
% DIM(1:3)     - image size 
% VOX(1:3)     - voxel size [mm]
% ORIGIN(1:3)  - origin [voxel index]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[hdr, filetype] = load_nii_hdr_cbi(imagefile);

dim    = hdr.dime.dim(2:4);
vox    = hdr.dime.pixdim(2:4);

dim    = dim(:)';
vox    = vox(:)';

if nargout==2, return; end;

if filetype	== 0
	origin = hdr.hist.originator(1:3);
else
	nii.hdr = hdr;
	nii.filetype = filetype;
	
	[orient, R, T] = get_orient_info(nii);
	
	origin = - T;
	
	origin = origin(:)'; 
end

return
