function	[status, nifti_filename] = convert_dicom_nifti_cmd(fname,outdir,prog_path,opt)
% Convert DICOM to NIFTI by using dcm2niix
%  status = convert_dicom_nifti_cmd(fname,outdir,prog_path,opt)
% --- Input
% fname : one of DICOM file 
%         All the files in DICOM image should be saved in the same directory
% --- Output
%         status : execute status (=0:success)
% nifti_filename : output nifti filename(without path)
% --- Optional Input
% outdir : Directory for output file 
%          if this is not specified, output file is saved in the same directory
% opt    : option string (See the following option rule)
%
% prog_path : path for 'dcm2niix' program 
%
% ---- Output file name convention
%  Options :
%   -1..-9 : gz compression level (1=fastest..9=smallest, default 6)
%   -a : adjacent DICOMs (images from same series always in same folder) for faster conversion (n/y, default n)
%   -b : BIDS sidecar (y/n/o [o=only: no NIfTI], default y)
%    -ba : anonymize BIDS (y/n, default y)
%   -c : comment stored in NIfTI aux_file (provide up to 24 characters e.g. '-c first_visit')
%   -d : directory search depth. Convert DICOMs in sub-folders of in_folder? (0..9, default 5)
%   -e : export as NRRD (y) or MGH (o) instead of NIfTI (y/n/o, default n)
%   -f : filename (%a=antenna (coil) name, %b=basename, %c=comments, %d=description, %e=echo number, %f=folder name, %g=accession number, %i=ID of patient, %j=seriesInstanceUID, %k=studyInstanceUID, %m=manufacturer, %n=name of patient, %o=mediaObjectInstanceUID, %p=protocol, %r=instance number, %s=series number, %t=time, %u=acquisition number, %v=vendor, %x=study ID; %z=sequence name; default '%f_%p_%t_%s')
%   -g : generate defaults file (y/n/o/i [o=only: reset and write defaults; i=ignore: reset defaults], default n)
%   -h : show help
%   -i : ignore derived, localizer and 2D images (y/n, default n)
%   -l : losslessly scale 16-bit integers to use dynamic range (y/n/o [yes=scale, no=no, but uint16->int16, o=original], default o)
%   -m : merge 2D slices from same series regardless of echo, exposure, etc. (n/y or 0/1/2, default 2) [no, yes, auto]
%   -n : only convert this series CRC number - can be used up to 16 times (default convert all)
%   -o : output directory (omit to save to input folder)
%   -p : Philips precise float (not display) scaling (y/n, default y)
%   -r : rename instead of convert DICOMs (y/n, default n)
%   -s : single file mode, do not convert other images in folder (y/n, default n)
%   -u : up-to-date check
%   -v : verbose (n/y or 0/1/2, default 0) [no, yes, logorrheic]
%   -w : write behavior for name conflicts (0,1,2, default 2: 0=skip duplicates, 1=overwrite, 2=add suffix)
%   -x : crop 3D acquisitions (y/n/i, default n, use 'i'gnore to neither crop nor rotate 3D acquistions)
%   -z : gz compress images (y/o/i/n/3, default n) [y=pigz, o=optimal pigz, i=internal:zlib, n=no, 3=no,3D]
%   --big-endian : byte order (y/n/o, default o) [y=big-end, n=little-end, o=optimal/native]
%   --progress : Slicer format progress information (y/n, default n)
%   --ignore_trigger_times : disregard values in 0018,1060 and 0020,9153
%   --terse : omit filename post-fixes (can cause overwrites)
%   --version : report version
%   --xml : Slicer format features
%  Defaults file : /home/cbi/rhayashi/.dcm2nii.ini
%  Examples :
%   dcm2niix /Users/chris/dir
%   dcm2niix -c "my comment" /Users/chris/dir
%   dcm2niix -o /users/cr/outdir/ -z y ~/dicomdir
%   dcm2niix -f %p_%s -b y -ba n ~/dicomdir
%   dcm2niix -f mystudy%s ~/dicomdir
%   dcm2niix -o "~/dir with spaces/dir" ~/dicomdir
% Example output filename: 'myFolder_MPRAGE_19770703150928_1.nii'

% option
% -ba y : Anonymize BIDS
% -f %i : Use patient ID in filename
% -t n  : No save patient details.
if ~exist('opt','var')
%    opt = ' -ba y -w 1 -f tmp_subject -t n ';
    opt = ' -ba y -w 1 -f %i -t n ';
else
	opt = [' ' opt ' '];
end

% output directory
if ~exist('outdir','var') || isempty(outdir)
	outdir = '.';
end
outdir_tmp = tempname(outdir);
mkdir(outdir_tmp);

% program
if ~exist('prog_path','var') || isempty(prog_path)
    [arch] = computer;
	if ispc
		prog_path = which('dcm2niix.exe');
	elseif strcmp(arch, 'GLNX86') || strcmp(arch, 'GLNXA64')
        prog_path = which('dcm2niix_linux64.');
    else
		prog_path = which('dcm2niix_mac.');
	end
end
if ~ispc
    [stat, mess] = fileattrib(prog_path);
    if mess.UserExecute ~= 1
        fprintf('trying to change permission of dcm2niix executable.\n');
        [stat2, mess] = fileattrib(prog_path, '+x');
        if stat2 ~= 1
            error([prog_path ' need to have executable permission.']);
        end
    end
end

prog_path = dblquote(prog_path);
cmd  = [prog_path, opt, ' -o ' dblquote(outdir_tmp) ' ', dblquote(fname), ...
        ' > ' dblquote([outdir_tmp, '/dcm2niix.log'])];
fprintf('command: %s\n', cmd);
[status] = system(cmd);

% get nifti filename
d = dir(fullfile(outdir_tmp, '*.nii'));
nifti_filename = d.name;
nifti_file     = fullfile(outdir, nifti_filename);

% move to output directory
movefile(fullfile(outdir_tmp, '*.nii'), outdir, 'f');
rmdir(outdir_tmp, 's');

%status = dos(cmd, '-echo');

function q_str = dblquote(str)

q_str = ['"', str, '"'];

