function [nerr,nerr_ts,errors]=lcd_prediction_errors(Z,Zpred)
% COMPUTE PREDICTION ERROR
%
% [Input]
% Z : original timeseries  [Nv Nt]
% Zpred : predicted timeseries [Nv Nt] 
%
% [Output]
% nerr : normalized square errors (error variance) [scalar]
% nerr_ts : time-point-wise normalized square error [1 Nt] 
% errors : error timeseries [Nv,Nt]
%
% 2016/03/24 O.Yamashita
% * [Add] add nerr_ts as output
% 2016/02/02 O.Yamashita

errors = Z - Zpred;
nerr = sum(sum((Z(:,:)-Zpred(:,:)).^2))/sum(sum(Z(:,:).^2));
nerr_ts = sum((Z(:,:)-Zpred(:,:)).^2,1)./sum(Z(:,:).^2,1);
