function [A,B,C,Xc]= lcd_fitrbfmar_fukushima(X,Delta,ti,s2, varargin)
%
% [Input] 
%  X :
% Delta :
%  ti : center time points of rbf kernel
% s2  : rbf kernel width 
%
% 2016/03/22 O.Yamashita


parm = finputcheck(varargin, ...
    {'nlearn'     ,'integer',  [1 inf],  100;...
     'lam0'       ,'real'   ,  []     ,  1e-4;...
     'beta0'      ,'real'   ,  [0 inf],  1;...
     'd0'         ,'real'   ,  [0 inf],  1;...   
     });
 
if ~isstruct(parm)
   error(parm);
end

Nlearn = parm.nlearn;
lam0  = parm.lam0;
beta0 = parm.beta0;
d0    = parm.d0;

dmax = max(Delta(:));
[Nv,Nt]=size(X);

% make input regressors
for d = 1 : length(ti)
    Xc(:,d) = exp(-([dmax+1:Nt]'-ti(d)).^2/s2);
end
XcXc=Xc'*Xc;


A = zeros(Nv,1);
B = zeros(Nv,Nv);
C = zeros(Nv,length(ti));

for vv = 1 : Nv

    y = X(vv,dmax+1:Nt)';
    ix = find(Delta(vv,:)~=0);

    
    Xb = [];
    for uu = 1 : length(ix)
        if ix(uu) == vv
            Xa = X(vv,dmax+1-Delta(vv,vv):Nt-Delta(vv,vv))';
        else
            Xb = [Xb X(ix(uu),dmax+1-Delta(vv,ix(uu)):Nt-Delta(vv,ix(uu)))'];
        end
    end

    if isempty(Xb)
        Xb = 0;
        lam0 = 1;
        emptyXb = 1;
    else
        emptyXb = 0;
    end
    XbXb = Xb'*Xb;
    XaXa = Xa'*Xa;
 

    %
    % learning
    %

    lam = lam0;
    beta = beta0;
    a    = zeros(size(Xa,2),1);
    c    = zeros(size(Xc,2),1);
    d    = d0*ones(size(Xc,2),1);

    for nn = 1 : Nlearn


        Pb = beta*XbXb+lam*eye(size(Xb,2));  % Pb = beta*Xb'*Xb+lam*eye(size(Xb,2));
        Sb = inv(Pb);
        b = Sb *(Xb'*(y-Xa*a-Xc*c)*beta);

        Pa = beta*XaXa; %Pa = beta*Xa'*Xa;
        Sa = inv(Pa);
        a  = Sa*(Xa'*(y-Xb*b-Xc*c)*beta);

        Pc = beta*XcXc+diag(d); % Pc = beta*Xc'*Xc+diag(d);
        Sc = inv(Pc);
        c = Sc*(Xc'*(y-Xa*a-Xb*b)*beta);

%        d = 1./(diag(Sc)+c.^2);
        d = (1 - c.^2)./diag(Sc);
        lam = length(b)/(b'*b+trace(Sb));
%        beta = (Nt-dmax)/(sum((y-Xa*a-Xb*b-Xc*c).^2)+trace(Xa'*Xa*Pa)+trace(Xb'*Xb*Pb)+trace(Xc'*Xc*Pc));
%        beta = (Nt-dmax)/(sum((y-Xa*a-Xb*b-Xc*c).^2)+trace(XaXa*Pa)+trace(XbXb*Pb)+trace(XcXc*Pc));
        beta = (Nt-dmax)/(sum((y-Xa*a-Xb*b-Xc*c).^2)+sum(sum(XaXa.*Pa'))+sum(sum(XbXb.*Pb'))+sum(sum(XcXc.*Pc')));

    end

    
    if emptyXb
        A(vv) = a;
        C(vv,:) = c;
    else
        A(vv) = a;
        B(vv,setdiff(ix,vv)) = b;
        C(vv,:) = c;
    end


end
