function	[Vmni] = load_connection_dti(parm);
% Connection pair coordinate file
% parm.conn_file 
% parm.atlas_file 
% parm.brainfile
% Vmni{n} : vertex 3D coordinate for n-th connections (MNI-mm)
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(parm.conn_file, 'Vtracks', 'Index_to', 'Index_from');

Data.Vc = Vtracks;
Data.I_to  = Index_to;
Data.I_from= Index_from;

[V, id] = reduce_connection(Data, parm);

[Vc, Nc] = cell_to_mat(V);

%return

[Vmni , IMGinfo] = trans_subj_mni_coord(Vc,parm);

Vmni = mat_to_cell(Vmni,Nc);
