function	[key,keypair] = get_area_key(conn_file,areafile,Nmin)
% get_area_key from conn_file
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3, Nmin = 1; end;

load(conn_file);
% Index_toνȤʤĺǤΥǥå
% Index_fromεȤʤĺǤΥǥå

keyset = vb_get_keyset_area(areafile);
Narea = length(keyset);

NP = length(Index_to);
% NP = 10;
fprintf('number of connections = %d\n',NP)

alist = zeros(NP,2);
Ndisp = 100;

Areas = [];
for n=1:Narea
    Areas = [Areas; vb_get_area(areafile, keyset{n})];
end
% find area index for pair
for i=1:NP
	for n=1:Narea
		flg1 = any(Areas(n).Iextract==Index_to(i));
		flg2 = any(Areas(n).Iextract==Index_from(i));
		
		if flg1==1 , alist(i,1) = n; end
		if flg2==1 , alist(i,2) = n;end
	end
	fprintf('.')
	if rem(i,Ndisp)==0, fprintf('\n'); end
end

%--- find unique pair
[alist, jj] = sortrows(alist);
% diff of rows
adif = alist(1:NP-1,:)-alist(2:NP,:);
% if zero, the same index is continued
% find changed row for unique components
ix = find( sum(abs(adif),2) > 0);
% first row always selected
ix = [1; ix+1];

% pair of area index
apair = alist(ix,:);
% connections list index
ipair = jj(ix);

% number of connections for area pair
npair = [ix(2:end) ; NP+1] - ix;

% select non-empty ibdex
ii = find( sum(apair > 0,2) == 2);

[tmp, jx] = sort(npair(ii), 1, 'descend');

%--- area key for pair of connection vertex
keypair.num   = npair(ii(jx));
keypair.index = ipair(ii(jx));
keypair.to    = {keyset{apair(ii(jx),1)}};
keypair.from  = {keyset{apair(ii(jx),2)}};

%--- unique area list
alist1 = sort(alist(:));
adif = alist1(1:end-1)-alist1(2:end);
% find changed indx for unique components
jx = find( abs(adif) > 0);

jx = [1; jx+1];
% number of connections for area 
num = [jx(2:end) ; 2*NP+1] - jx;
alist2 = alist1(jx);
kx = find(alist2 > 0);
% unique area key list
key = {keyset{alist2(kx)}};
num = num(kx);

alist3 = sort(unique(alist1));

err = sum(abs(alist3 - alist1(jx)));

if err > 0, error('unique algorithm error'); end;

[num,kx] = sort(num, 1, 'descend');
key = {key{kx}};

fname = 'pair_area.txt';
fprintf('---- Output area list file: %s\n',fname)

fid   = fopen(fname,'w');

if fid==-1,error('can not open file'); end;

for n=1:length(key)
	fprintf(fid,'%s: num=%d\n',key{n},num(n));
end

fprintf(fid,'\n\n---- pair of area\n\n');

Npair = length(keypair.num);

for n=1:Npair
	fprintf(fid,'num = %d, ', keypair.num(n));
	fprintf(fid,'from = %s ,',keypair.from{n});
	fprintf(fid,'to = %s\n',keypair.to{n});
end

fclose(fid);

kk  = find(num >= Nmin);
key = {key{kk}};
%
