function movie_combine(avi_lr_file, avi_tb_file, output_file, title_str, left_is_left)
% Combine two avi files(bottom/right view) into single avi file with a
% title.
% [Usage]
%    movie_combine(avi_right_file, avi_bottom_file, output_file[, title_str][,left_is_left]);
% [Input]
%    avi_lr_file     : left/right view avi file.
%    avi_tb_file     : top/bottom view avi file.
%    output_file     : output avi file.
%    title_str       : [optional] 
%    left_is_left    : =  true : left side is 'L'. : top view
%                      = false : left side is 'R'. : bottom view
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('title_str', 'var')
    title_str = 'Right View/Bottom View';
end
if ~exist('left_is_left', 'var')
    left_is_left = true;
end

%
% --- AVI Video files
%
if nargin < 2
    avi_dir = '\\cbi-data4\cbi-data4\rhayashi\dynamics_movie\face_naive\20151111\parm01\Sub10\movie';
    avi_tb_file = fullfile(avi_dir, 'bottom_view.avi');
    avi_lr_file   = fullfile(avi_dir, 'right_view.avi');
    disp('Example : ');
end

%
% --- Read Video
%
disp(['avi file(left/right view) : ' avi_lr_file]);
disp(['avi file(top/bottom view): ' avi_tb_file]);
video_right  = VideoReader(avi_lr_file);
video_bottom = VideoReader(avi_tb_file);

vr_data = read(video_right);
vb_data = read(video_bottom);

%
% ---- Figure setup
%
disp('Started to play video.');
close all;
h = figure;
set(h, 'Unit', 'pixels');
set(h, 'Position', [100, 200, 1280, 768]);
set(h, 'Menubar', 'none');
set(h, 'Color', 'k');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RightView/BottomView Area
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_axes_r = axes;
h_axes_b = axes;

%%%%%%%%%%%%%
% Title
%%%%%%%%%%%%%
title_font_size = 25;
h_title = axes; axis off;
set(h_title, 'Units', 'pixels', 'Position', [70, 680, 1, 1]);
title(h_title, title_str, 'FontSize', title_font_size, 'Color', [1 1 1], 'HorizontalAlignment', 'left');
                
%%%%%%%%%%%%%
% L/R label                
%%%%%%%%%%%%%
if left_is_left
    label_strL = 'L';
    label_strR = 'R';
else
    label_strL = 'R';
    label_strR = 'L';
end
label_font_size = 25;

h_labelL = axes; axis off;
set(h_labelL, 'Units', 'pixels', 'Position', [680,380, 1, 1]);
title(h_labelL, label_strL, 'FontSize', title_font_size, 'Color', [1,1,1], 'HorizontalAlignment', 'left');

h_labelR = axes; axis off;
set(h_labelR, 'Units', 'pixels', 'Position', [1190, 380, 1, 1]);
title(h_labelR, label_strR, 'FontSize', title_font_size, 'Color', [1,1,1], 'HorizontalAlignment', 'left');

%%%%%%%%%%%%%%%%                
% Create Frames
%%%%%%%%%%%%%%%%
numFrames = get(video_bottom, 'numberOfFrames');
frames(numFrames) = struct('cdata', [], 'colormap', []); % pre-allocate


for k=1:numFrames
    % plot right view
    cla(h_axes_r);
    image(vr_data(:, :, :, k), 'Parent', h_axes_r);
    set(h_axes_r, 'Unit', 'pixels');
    set(h_axes_r, 'Position', [-70, -20, video_right.Width, video_right.Height]);
    axis(h_axes_r, 'off');
    if nargin <= 2
        pause(0.03);
    end

    % plot bottom view
    cla(h_axes_b); 
    set(h_axes_b, 'Unit', 'pixels');
    image(vb_data(:, :, :, k), 'Parent', h_axes_b);
    set(h_axes_b, 'Position', [550, -20,video_bottom.Width, video_bottom.Height]);
    axis(h_axes_b, 'off');
    drawnow;
    frames(k) = getframe(h);
end

%
% --- Write AVI file
%
if exist('output_file', 'var') && ~isempty(output_file)
    writer = VideoWriter(output_file);
    % set Frame Rate, Quality
    writer.FrameRate = video_bottom.FrameRate;
    writer.Quality   = 100;
    open(writer);

    disp('saving video...');
    writeVideo(writer, frames);
    close(writer);
    disp(['avi file(combined): ' output_file]);
end