function save_mask_coordinate(dir_name, qfile, ofile, Nlabel, niftigz_file)
% Save mm coordinates of mask voxels
%
% [Input]
%       dir_name: directory name where voxel images made by 'fsl2ascii' locate
%          qfile: Ascii qform values from 'fslorient -getqform (input) > (filename)'
%          ofile: Output file containing mm coodinate of all the voxels in the mask
%   niftigz_file: NIfTI-gz MRI image file.
%
% [Output]
%    none
%
% 2012/06/13 M.Fukushima
% 2013/08/03 M.Fukushima
% 2014/05/27 rhayashi     remove Nx, Ny, Nz and add niftigz_file
%                                (Get voxel dimension from this file.)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if nargin ~= 5
    error('Please check input arguments.');
end
if exist(dir_name, 'dir') ~= 7
    error('Specified directory not found.');
end
if exist(qfile, 'file') ~= 2
    error('Specified qfile not found.');
end
output_dir = fileparts(ofile);
if exist(output_dir, 'dir') ~= 7
    mkdir(output_dir);
end
if exist(niftigz_file, 'file') ~= 2
    error('Specified niftigz_file not found.');
end

%
% --- Main Procedure
%

% Get MRI infomation
mri_info_file = tempname;

cmd = ['fslinfo', ...
       ' '  , niftigz_file, ...
       ' > ', mri_info_file];
[a, ret] = dmri_system(cmd);

% Get voxel dimension
[field, val_str] = textread(mri_info_file, '%s %s');
Nx = str2double(val_str{strmatch('dim1', field)});
Ny = str2double(val_str{strmatch('dim2', field)});
Nz = str2double(val_str{strmatch('dim3', field)});
delete(mri_info_file);


% mm coordinate
mcoord = [];
label = [];
for ii= 1:Nlabel
  ind = num2str(ii);
  vfile = [dir_name '/parcel' ind '-v.asc'];
  tmp_c = get_mask_coordinate(vfile, qfile, Nx, Ny, Nz);
  tmp_l = ones(1,size(tmp_c,1))*ii;
  mcoord = [mcoord tmp_c'];
  label = [label tmp_l];
  if mod(ii,100)==0
    fprintf('%d/%d done.\n',ii,Nlabel);
  end
end
fprintf('All Done.\n');
mcoord = mcoord';
label = label';
save(ofile, 'mcoord', 'label', 'Nlabel');
