function pairs = get_pairs_undir(C)
%
% [Input] 
%   C : undirected connectivity matrix 
% [Output] 
%   pairs_bi : 1st and 2nd column -> two vertex points of an edge, 3rd
%                 column -> connectivity label  1 = bi, 0 = uni.
%
% [Example] 
%   pairs    = [1 2
%               1 3]
% means un-directed connectivity between (1,2) and (1,3)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

C = triu(C,1); % upper diagonal components
[I,J]=find(C ~= 0);
pairs =[I J];

