function brain_image_extract(niftigz_file, threshold)
% delete non-brain tissues from an image of the whole head by FSL bet command.
%
% [Usage]
%    brain_image_extract(nifti_gz_file, threshold);
%
% [Input]
%    niftigz_file : gzipped NIfTI Image file(.nii.gz)
%       threshold : fractional intensity threshold (0->1); 
%                   default=0.5; smaller values give larger brain 
%                   outline estimates.
% [Output]
%    none
%
% [Output files]
%    extracted brain image file:
%       gzipped Nifti file(.nii.gz)
%    brain mask file:
%       gzipped Nifti file(.nii.gz)
%       A single binarised volume in diffusion space containing ones 
%       inside the brain and zeroes outside the brain.
%
% [See also]
%    http://fsl.fmrib.ox.ac.uk/fsl/fslwiki/BET
%
% [Example]
%    brain_image_extract('/home/cbi/data_ecc.nii.gz', 0.18);
%      put these files into the same directory.
%      (_brain, _brain_mask is added.)
%        /home/cbi/data_ecc_brain.nii.gz
%        /home/cbi/data_ecc_brain_mask.nii.gz
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('niftigz_file', 'var')
    error('Please check input arguments.');
end
if exist(niftigz_file, 'file') ~= 2
    error('Specified niftigz_file not found');
end
if ~exist('threshold', 'var')
    threshold = 0.5;
end

%
% --- Main Procedure
%
fprintf('brain extraction(threshold:%.2f)...', threshold);
[p, f, e] = fileparts(niftigz_file(1:end-7)); % -7 means '.nii.gz'
output_basename = [p, '/', f, '_brain'];
command = ['bet ', niftigz_file, ' ', ...
                   output_basename, ...
                   ' -m', ...             % -m: generate binary brain mask
                   ' -f ', num2str(threshold), ... % -f: fractional intensity
                   ' -R '];
[status, cmdout] = dmri_system(command, '-echo');
if status ~= 0
    error('Please check input arguments.');
end
fprintf('done.\n');

