function dmri_process_images_coregister(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

if isfield(p, 'ref_fs_dir') && ~isempty(p.ref_fs_dir)
    freesurfer_dir = p.ref_fs_dir;
else
    freesurfer_dir = fullfile(p.output_dir, p.fs_dirname, p.fs_sbj_name);
end

if exist(freesurfer_dir, 'dir') ~= 7
    error('Specified Freesurfer directory not found : %s', freesurfer_dir);
end

struct_brain_file = fullfile(p.output_dir, p.t1_dirname, [p.t1_brain_basename, '_brain.nii.gz']);
fa_file           = fullfile(p.output_dir, p.dwi_dirname, [p.FA_coreg_basename, '.nii.gz']);
output_dir        = fullfile(p.output_dir, p.transform_info_dirname);

%
% --- Coregister images using brain(not whole head) image.
%      
dmri_transwarp_info_create(freesurfer_dir, struct_brain_file, fa_file, output_dir);
