function dmri_process_fiber_tracking_mask_create(p)
% Create Fiber tracking mask file
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Create White matter volume file on FA coordinate system.
%
if isfield(p, 'ref_fs_dir') && ~isempty(p.ref_fs_dir)
    fs_dir = p.ref_fs_dir;
else
    fs_dir = fullfile(p.output_dir, p.fs_dirname, p.fs_sbj_name);
end

ref_brain_file  = fullfile(p.output_dir, p.t1_dirname, [p.t1_brain_basename '_brain.nii.gz']);
ref_FA_file     = fullfile(p.output_dir, p.dwi_dirname, [p.FA_basename, '.nii.gz']);
trans_info_dir  = fullfile(p.output_dir, p.transform_info_dirname);

wm_file         = fullfile(p.output_dir, p.fiber_track_dirname, 'wm.nii.gz');

dmri_wm_FA_volume_create(fs_dir, ...
                        ref_brain_file, ref_FA_file, trans_info_dir, ...
                        wm_file);

%
% --- Merge Parcel all + White matter
%
parcel_all_file = fullfile(p.output_dir, p.parcels_dirname, 'parcel_all.nii.gz');
parcel_wm_file  = fullfile(p.output_dir, p.fiber_track_dirname, p.fiber_mask_file);

% parcel_all_file + wm_file = parcel_wm_file
dmri_merge_parcels_wm(parcel_all_file, wm_file, parcel_wm_file);
