%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
root = '/home/cbi/rhayashi/temp/dynamics_movie/data';

% Load current & MAR matrix
dbayes_file  = fullfile(root, '/dynamics_estimation/estimation_result.dbayes.mat');
load(dbayes_file,  'Model');
Zact = Model.Z{1};
MAR = Model.MAR;

% Choose strong pairs
Npairs = 100;
current_threshold = 0.0207;
Econ = MAR-diag(diag(MAR));
[parcel_to_list,parcel_from_list] = dmri_select_pairs_for_movie(Zact, Econ, Npairs, current_threshold);

fprintf('Number of pairs : %d\n', length(parcel_to_list));

dmri_file        = fullfile(root, '/dmri/connectivity/connectivity.dmri.mat');
parcel_dir       = fullfile(root, '/dmri/parcels');
mif_file         = fullfile(root, '/dmri/fibertrack/CSD6.mif');
mask_file        = fullfile(root, '/dmri/fibertrack/wm.nii.gz');
fa_gz_file       = fullfile(root, '/dmri/DWI/data_FA.nii.gz');
trans_info_dir   = fullfile(root, '/dmri/transwarp_info');
fs_brain_gz_file = fullfile(root, '/freesurfer/Subject/mri/brain.nii.gz');


% Output directory(filename is fixed : Vmni_connect.mat)
output_dir       = '~/dynamics_movie';

% Fiber tracking hosts(Do not specify a host that runs this script.)
% Available hosts
% - cbi-node20-33
% - cbi-node01g-08g
% - cbi-node20g-23g
process_host     = {'cbi-node01g', 'cbi-node02g','cbi-node03g'};

% The number of MATLAB processes which are used to process fiber tracking result files.
Nworker          = 20;

dmri_fiber_track_prob_specific_pair(parcel_dir, parcel_from_list, parcel_to_list, ...
                              mif_file, mask_file, ...
                              fa_gz_file, fs_brain_gz_file, trans_info_dir, dmri_file, ...
                              output_dir, process_host, Nworker);



