function dmri_process_T1_brain_extract(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
disp(mfilename);

%
% --- Convert T1 to FSL format(nii.gz) and Skull stripped brain
%
if isfield(p, 'ref_mri_file') && ~isempty(p.ref_mri_file)
    mri_file = p.ref_mri_file;
else
    mri_file = fullfile(p.output_dir, p.t1_dirname, ['m', p.t1_file]);
end

t1_parm.mri_file         = mri_file;
t1_parm.threshold        = p.t1_brain_threshold;
t1_parm.output_dir       = fullfile(p.output_dir, p.t1_dirname);
t1_parm.output_basename  = p.t1_brain_basename;

dmri_job_t1_preprocess(t1_parm);

% Check skull stripped brain image.
cmd = ['fslview ' ...
       fullfile(t1_parm.output_dir, [p.t1_brain_basename, '_brain.nii.gz']) ' ', ...
       fullfile(t1_parm.output_dir, [p.t1_brain_basename, '.nii.gz'])];
dmri_system(cmd);
