function dmri_image_transform(from_file, to_file, to_ref_file, ...
                              direction, transinfo_dir)
% Change coordinate system of specified image.
%
% [Usage]
%    dmri_image_transform(from_file, to_file, to_ref_file, ...
%                         direction, transinfo_dir);
%
% [Input]
%        from_file : original niftigz file.
%          to_file : transformed and newly create niftigz file.
%      to_ref_file : reference image file of to_file.
%        direction : transform direction   [string]
%                    'fs2struct'          : from freesurfer coord to T1 coord.
%                    'struct2fa'          : from T1 coord to FA coord.
%                    'struct2fa_nointerp' : from T1 coord to FA coord with interp.
%    transinfo_dir : The directory which is including transform files.
%                    This directory is made by dti_transwarp_info_create.m
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 5
    error('Please check input arguments.');
end
if exist(transinfo_dir, 'dir') ~= 7
    error(sprintf('transinfo_dir : %s not found.', transinfo_dir));
end

%
% --- Main Procedure
%

% get command
command = dmri_image_transform_cmd_get(from_file, to_file, to_ref_file, ...
                                      direction, transinfo_dir);

% Execute command
[status, cmdout] = dmri_system(command, '-echo');
if status ~= 0
    error('Please check input arguments');
end
