function vb_remove_island_atlas(brain_file,atlas_id)
% Remove islands of atlas labels using patch information
% Note that original act.mat and area.mat files will be overwritten.
%
% ---- Syntax
% vb_remove_island_atlas(parm)
%
% ---- Input
% brain_file  : brain file path
% atlas_id    : ID of atlas ['aal' or 'brodmann']
%
% 2016/5/27 Last modified by Y.Takeda
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('atlas_id','var')
    atlas_id='aal';
end

% Set file names
EXT_brain = '.brain.mat';
brain_id  = brain_file(1:findstr(brain_file,EXT_brain)-1);
area_file  = [brain_id '_' atlas_id '.area.mat'];
atlas_file = [brain_id '_' atlas_id '.act.mat'];

% Load atlas label to modify
act = vb_get_act(atlas_file,atlas_id);
area_list=unique(act.xxP(act.xxP>0));
Narea=length(area_list);

% Load patch information
[tmp,F]=vb_load_cortex(brain_file,'Inflate');
F0=F.F3;

% Start to find and remove island clusters
xxP=act.xxP;
xxP_old=xxP+1;
while 1
    
    % Find island clusters
    clear Area1
    for area1=1:Narea
        ix=find(xxP==area_list(area1));
        Nv1=length(ix);
        
        % Make clusters using patch information
        clear same
        for v1=1:Nv1
            a=find(F0(:,1)==ix(v1) | F0(:,2)==ix(v1) | F0(:,3)==ix(v1));
            f=F0(a,:);
            f=f(:);
            same(v1).ix=v1;
            for v2=v1+1:Nv1
                if ~isempty(find(f==ix(v2)))
                    same(v1).ix=[same(v1).ix,v2];
                end
            end
        end
        
        % Combine adjacent clusters
        while 1
            become_empty=0;
            for v1=1:Nv1-1
                for v2=v1+1:Nv1
                    if ~isempty(same(v2).ix)
                        ix2=[same(v1).ix,same(v2).ix];
                        if length(unique(ix2))<length(ix2)
                            same(v1).ix=unique(ix2);
                            same(v2).ix=[];
                            become_empty=1;
                        end
                    end
                end
            end
            if become_empty==0
                break
            end
        end
        
        % Extract combined clusters
        v2=1;
        for v1=1:Nv1
            if ~isempty(same(v1).ix)
                Area1(area1).cluster(v2).ix=ix(same(v1).ix);
                Area1(area1).Nvertex(v2)=length(same(v1).ix);
                v2=v2+1;
            end
        end
        
        % Define island clusters
        ix1=1:length(Area1(area1).Nvertex);
        [~,b]=max(Area1(area1).Nvertex);
        ix1(b)=[];
        Area1(area1).center=b;
        Area1(area1).island=ix1;
    end
    
    % Remove island clusters
    for area1=1:Narea
        Nisland=length(Area1(area1).island);
        if Nisland>0
            for island1=1:Nisland
                
                % Obtain surrounding labels of an island
                ix_island_cluster=Area1(area1).island(island1);
                vertices_in_an_island_cluster=Area1(area1).cluster(ix_island_cluster).ix;
                Nn=zeros(Narea,1);
                for v=1:length(vertices_in_an_island_cluster)
                    v2=vertices_in_an_island_cluster(v);
                    a=find(F0(:,1)==v2 | F0(:,2)==v2 | F0(:,3)==v2);
                    f=F0(a,:);
                    f=f(:);
                    ae=xxP(f);
                    ae=unique(ae(ae~=area_list(area1)));
                    for ae1=1:length(ae)
                        a=find(area_list==ae(ae1));
                        Nn(a,1)=Nn(a,1)+1;
                    end
                end
                
                % Change the label of the island to the most common surrounding label
                if sum(Nn)>0
                    [~,b]=max(Nn);
                    xxP(vertices_in_an_island_cluster)=area_list(b);
                else
                    xxP(vertices_in_an_island_cluster)=0;
                end
            end
        end
    end
    
    % Exit if xxP is not changed
    if norm(xxP-xxP_old)>0
        xxP_old=xxP;
    else
        break
    end
end

% Prepare for saving modified atlas label
Atlas.key = atlas_id;
Atlas.xxP = xxP;
Atlas.label = act.label;
Atlas.label_name = act.label_name;

if exist(atlas_file,'file')
    delete(atlas_file);
end
if exist(area_file,'file')
    delete(area_file);
end

% Save modified label as actfile
fprintf('Save modified atlas file\n');
vb_add_act(atlas_file,Atlas,[],false);

% Save modified area label into area file
fprintf('Save modified area file\n');
vb_save_atlas_label(area_file,Atlas.xxP,Atlas.label,Atlas.label_name);
