function	vb_plot_atlas_area(brainfile,Atlas,alpha_value)
% Plot brain atlas for motor and visual area
%  vb_plot_atlas_area(brainfile,Atlas)
%  vb_plot_atlas_area(brainfile,Atlas,alpha_value)
% --- Input
% brainfile
% Atlas : structure of atlas label
% alpha_value
%
% 2006-11-12 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('alpha_value', 'var'), alpha_value = 1; end

arealist = get_area_list;

[V, F, xx, inf_C] = vb_load_cortex(brainfile,'Inflate');

NL = F.NdipoleL;
FL = F.F3L;
FR = F.F3R;
F  = F.F3;
NV = size(V,1);

Narea = length(arealist);

[ixlist, Nlist] = vb_get_atlas_index(arealist,Atlas);

Maxlabel = sum(Nlist > 0);

% Ǿǥοѥ᡼
cscale = -0.4;
c0 = 0.8;
colors = inf_C * cscale  + c0;
colors = repmat(colors, [1 3]);

% ΰ򤳤οɽ
cmap = vb_get_class_color(Maxlabel);
angl = [ 10 45 ; -10 45; -60 10; 60 10; 35  20; -35  20];

Lmax = max(V(1:NL,:));
Lmin = min(V(1:NL,:));
Rmax = max(V((NL+1):NV,:));
Rmin = min(V((NL+1):NV,:));

subplot(1,2,1)
patch('Faces',FL,'Vertices',V,'FaceColor','interp',...
	'EdgeColor','none','FaceVertexCData',colors);
hold on;

ncolor = 0;

for n=1:Narea
	Fx = vb_patch_select2(ixlist{n},FL,NV);
	if isempty(Fx), continue; end
	
	ncolor = ncolor + 1;
	vb_plot_surf(V,Fx,cmap(ncolor,:));
end

xlim([Lmin(1) Lmax(1)]);
ylim([Lmin(2) Lmax(2)]);
zlim([Lmin(3) Lmax(3)]);

view(angl(1,:));
alpha(alpha_value);

subplot(1,2,2)
patch('Faces',FR,'Vertices',V,'FaceColor','interp',...
	'EdgeColor','none','FaceVertexCData',colors);
hold on;

ncolor = 0;

for n=1:Narea
	Fx = vb_patch_select2(ixlist{n},FR,NV);
	if isempty(Fx), continue; end

	ncolor = ncolor + 1;
	vb_plot_surf(V,Fx,cmap(ncolor,:));
end

xlim([Rmin(1) Rmax(1)]);
ylim([Rmin(2) Rmax(2)]);
zlim([Rmin(3) Rmax(3)]);

view(angl(2,:));
alpha(alpha_value);

return

function	arealist = get_area_list()

arealist = { ...
%
%	Motor area
%
	'Precentral_L';     ...
	'Postcentral_L';    ...
	'Supp_Motor_Area_L'; ...
	'Parietal_Sup_L';    ...
	'Precentral_R';     ...
	'Postcentral_R';    ...
	'Supp_Motor_Area_R'; ...
	'Parietal_Sup_R';    ...
%
%	Visual area
%
    'Calcarine_L'
    'Calcarine_R'
    'Occipital_Sup_L';
    'Occipital_Sup_R';
    'Occipital_Mid_L';
    'Occipital_Mid_R';
    'Occipital_Inf_L';
    'Occipital_Inf_R';
    'Cuneus_L'
    'Cuneus_R'
    'Fusiform_L'
    'Fusiform_R'
%
%	Motor area
%
    'brodmann area 1_L'; ...
    'brodmann area 2_L'; ...
    'brodmann area 3_L'; ...
    'brodmann area 4_L'; ...
    'brodmann area 5_L'; ...
    'brodmann area 6_L'; ...
    'brodmann area 7_L'; ...
    'brodmann area 8_L'; ...
    'brodmann area 1_R'; ...
    'brodmann area 2_R'; ...
    'brodmann area 3_R'; ...
    'brodmann area 4_R'; ...
    'brodmann area 5_R'; ...
    'brodmann area 6_R'; ...
    'brodmann area 7_R'; ...
    'brodmann area 8_R'; ...
%
%	Visual area
%
    'brodmann area 17_L'; ...
    'brodmann area 18_L'; ...
    'brodmann area 19_L'; ...
    'brodmann area 17_R'; ...
    'brodmann area 18_R'; ...
    'brodmann area 19_R'; ...
	};

