function	vb_atlas2vb_aal(parm)
% vb_atlas2vb_aal create an area indices
%   based on the Automated anatomical labeling 'aal'-atlas
% ---- Syntax
% vb_atlas2vb_aal(parm)
%
% ---- Input
% fields in 'parm'
% atlas_dir      : Dir of atlas file 'aal.img'
% save_areafile  : Area file saved
% save_atlasfile : Atlas file saved
% save_xyzfile   : MNI & Talairach coordinate file
% brainfile      : brain file;
%
%
% --- Function required  
%  explode      : string manupilation 
%
% ---- NOTE -----
% When using the normalize transformation matrix created by 'spm99',  
% back transformation results with a little shift 
% toward X(Left-Right) direction compared with brain file.
% It is highly recommended to recalculate 
% the transformation matrix by spm2 !!!
%
% 2005/03/03 OY
% 2005/03/28 modified 
% 2005/04/21 second part modified
% 2005/09/09 ver.030b compatible
% 2005/12/22 M.Sato
% 2006/2/3   M.Sato
% 2006/11/14 M.Sato
% 2007/03/05 OY
% * MNI coordinate is stored in brainfile.
% * save_xyzfile is removed.
% * A label for 'Corpus' is NaN.
% 2009-01-05 Taku Yoshioka
%   Supression of confirmation dialog
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% ---- Define aal-atlas
%

% Max value corresponding to Cerebrum cortex region in aal-atlas
%  1-90: Cerebrum, 91-108: Cerebellum, 109-116: Vermis
MaxLabel   = 90;	

atlas_dir  = parm.atlas_dir;
atlas_id   = 'aal';
atlas_text = [atlas_dir 'aal.txt'];
atlas_file = [atlas_dir 'aal.img'];
brainfile  = parm.brainfile;

save_areafile  = parm.save_areafile;
save_atlasfile = parm.save_atlasfile;

% Max radius to check minimum distance to corresponding point [mm]
if	isfield(parm,'Rlimit')
	Rlimit = parm.Rlimit;
else
	Rlimit = 4; 
end

% Max radius to search corresponding point [mm] in the 1st-step
if	isfield(parm,'Rmax')
	Rmax = parm.Rmax;
else
	Rmax = 2; 
end

% In the 1st-step, nearest point is searched within Rmax
% In the 2nd-step, nearest point is searched for all candidates
% This value determine, efficiency of search,
% but does not change the result

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Don't modify %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Template file is neurological format (right handed spm).

% ----- Corpus label
corpus_key   = 'Corpus';
corpus_label = NaN;

%
% ---- Load MNI-mm-coordinate for subject brain (should be calculated before)
%
warning('off', 'MATLAB:load:variableNotFound');
load(brainfile, 'Vmni','derr');
warning('on', 'MATLAB:load:variableNotFound');
if ~exist('derr', 'var'), derr = zeros(size(Vmni,1), 1); end
XYZmm = Vmni*1000;   % mm
dd    = derr*1000;   % mm

[Npoint, NdipoleL] = vb_load_cortex_info(brainfile);
Vlabel	 = zeros(Npoint,1);
dd_label = zeros(Npoint,1);


Vindx = [1:Npoint];
%
% ----- Remove corpus
%
% fprintf('---  Remove corpus region\n');
% [Vindx, Iremove] = vb_remove_corpus_run(brainfile);
% Vlabel(Iremove)  = corpus_label;
% 
% fprintf('# of Corpus points = %d\n',length(Iremove))

%
% ---- Load Atlas template file
%

% Read image-header
[dim, Trans, XYZmm0] = vb_get_image_info(atlas_file);

% Read atlas-template image 
% Z    - 3D image data
%Zlabel = read_image(atlas_file);

avw = avw_img_read(atlas_file);
Zlabel = avw.img;

% Zlabel - 3D image data (label value)
% XYZmm0 - 3 x n matrix of XYZ locations 
%        mm-coordinates in atlas-template (origin is specified by image file)
Zlabel = Zlabel(:);

% Extract labeled region
mni_id = find(Zlabel ~= 0); 
Zlabel = Zlabel(mni_id);
XYZmm0 = XYZmm0(:,mni_id)';

%
% ---- Left brain (Left label is odd integer in 'aal')
%
ix_L  = find( mod( Zlabel, 2 ) == 1 & Zlabel < MaxLabel);
ix_LV = Vindx( Vindx <= NdipoleL );

fprintf('# of Left template points = %d\n',length(ix_L))
fprintf('# of Left brain points    = %d\n',length(ix_LV))

fprintf('--- Mapping Atlas-label onto 2D cortical surface \n');

% Find nearest labeled point in atlas
[indx, dd_tmp] = ...
		vb_find_nearest_point(XYZmm0(ix_L,:), XYZmm(ix_LV,:), Rmax, 100, 0, 1);

fprintf('# of matched Left brain points    = %d\n',length(indx))

% Find points whose minimum distance to atlas brain region is less than Rlimit
ix_match = find( dd(ix_LV) <= Rlimit & dd_tmp < Rmax & indx > 0 );
%ix_match = find( dd(ix_LV) <= Rlimit & dd_tmp < Rmax );

fprintf('# of close points in Left brain   = %d\n',length(ix_match))

% Map label to subject cortex
Vlabel(ix_LV(ix_match)) = Zlabel(ix_L(indx(ix_match)));
dd_label(ix_LV) = dd_tmp;
%
% ---- Right brain (Right label is even integer in 'aal')
%
ix_R  = find( mod( Zlabel, 2 ) == 0 & Zlabel <= MaxLabel);
ix_RV = Vindx( Vindx > NdipoleL );

fprintf('# of Right template points = %d\n',length(ix_R))
fprintf('# of Right brain points    = %d\n',length(ix_RV))

fprintf('--- Mapping Atlas-label onto 2D cortical surface \n');

% Find nearest labeled point in atlas
[indx, dd_tmp] = ...
		vb_find_nearest_point(XYZmm0(ix_R,:), XYZmm(ix_RV,:), Rmax, 100, 0, 1);

fprintf('# of matched Right brain points    = %d\n',length(indx))

% Find points whose minimum distance to atlas brain region is less than Rlimit
ix_match = find( dd(ix_RV) <= Rlimit & dd_tmp < Rmax & indx > 0 );
%ix_match = find( dd(ix_RV) <= Rlimit & dd_tmp < Rmax );

fprintf('# of close points in Right brain   = %d\n',length(ix_match))

% Map label to subject cortex
Vlabel(ix_RV(ix_match)) = Zlabel(ix_R(indx(ix_match)));
dd_label(ix_RV) = dd_tmp;

% Fill label for large distant point
ixz    = find( dd_label >= Rmax );
fprintf('# of unlabeld point = %d\n', length(ixz))

%fprintf('Filling unlabeled points\n')
%Vlabel = vb_fill_atlas_label(brainfile, Vlabel, ixz, Rlimit);

%
% ---- Save labeled area
%
Nlabel = sum( Vlabel ~= 0 );	% # of labeled points
fprintf('# of all vertex     = %d\n',Npoint)
fprintf('# of cortex  points = %d\n',length(Vindx))
fprintf('# of labeled points = %d\n',Nlabel)

% Read atlas text file and extract area keys.
[label, label_name] = vb_read_atlas_label(atlas_text);

% Add Corpus label
Narea = length(label);
label(Narea+1) = corpus_label;
label_name{Narea+1} = corpus_key;

% Intensity of 'Act.xxP' is the label for each vertex
Atlas.key = [atlas_id];
Atlas.xxP = Vlabel;
Atlas.label      = label;
Atlas.label_name = label_name;
Atlas.dd_label   = dd_label;

% Save label as actfile
fprintf('Save the atlas file as "%s"  \n', save_atlasfile);
vb_add_act(save_atlasfile,Atlas,[],false);

% Save area label into area file
fprintf('Save the area file as "%s" \n', save_areafile);

vb_save_atlas_label(save_areafile,Vlabel,label,label_name);

clear Zlabel Vlabel XYZmm0 XYZmm Zlabel
