function	head_parm = vb_set_head_parm
% set head parameters for vb_job_head_3shell
%    head_parm = vb_set_head_parm;
% --- Setting for Output file  [relative path from 'proj_root']
% head_parm.head_file : Base name for head model
% --- Setting for Output surface
% head_parm.Nsurf   : Number of shell (=1 for MEG , =3 for EEG [default])
% head_parm.Nvertex : number of vertex in each surface 
%              = [2000] (Default)
%
% --- Setting for MRI input file  (Absolute path)
%   head_parm.analyze_file : MRI image file
%
% --- Setting for Scalp input file (Absolute path) [There are 2 cases]
%    If the following files are specified at the same time,
%    priority order is fs_scalp_file > face_file
% 1.  head_parm.face_file     : face file made by vbmeg
% 2.  head_parm.fs_scalp_file : FreeSurfer Scalp ('outer_skin_surface.asc')
%
% --- Setting for CSF input files (Absolute path) [There are 3 cases]
%   We recommend to use both FreeSurfer and Segment files:
%      'freesurf_file' + 'gray_file' + 'brain_file'
%
% 1. FreeSurfer file Case
%   head_parm.freesurf_file : FreeSurfer CSF ('inner_skull_surface.asc')
% 2. Segment file Case
%   head_parm.brain_file : Brain model file (.brain.mat)
%   head_parm.gray_file  : Gray matter segment file made by SPM 'Segment'
%
% 3. Curry file Case
%   head_parm.curry_file : Curry surface file
%
%%% --- Advanced Optional Parameter
% parm.Scalp_mode 
%     = 0 : Scalp surface is intersection of face and dilated CSF [Default]
%     = 1 : Scalp surface is smoothed face & Skull is the same as mode=0
%     = 2 : Scalp surface is smoothed face & Skull is erosion of face
%
% --- Optional setting for outer Skull surface   (Absolute path)
% parm.fs_skull_file : Outer Skull surface ('/outer_skull_surface.asc')
%
% --- Radius of Morphology operation [mm]
% If the obtained shell model is not good,
% you can adjust the following morphology radius parameters
%
% parm.Radius_scalp = 4 : Thickness of Scalp [mm]
% parm.Radius_skull = 2 : Min Thickness of Skull [mm]
% parm.Radius_fs  : smoothing radius for FreeSurfer surface
%                 = [4 -4 ] Default (No size change)
% parm.Radius_csf : smoothing radius for Gray matter
%                 = [6 6 -7 ] Default (Expand 6 mm)
% parm.Radius     : smoothing radius for CSF surface
%                 = [4 -4 ] Default (No size change)
% 
% parm.Nloop  = 200; Iteration number for fit boundary
% parm.Nlast_csf   = 10 ; Iteration number for CSF smoothing by spring model
%                    As Nlast becomes larger, surface becomes smoother
%                    but it shrinks inward
% parm.Nlast_scalp  = 0 ; Iteration number for Scalp
% parm.Nlast_skull  = 0 ; Iteration number for Skull
% (Gray matter parameters)
% parm.Glevel      = [0.8];  level of gray matter selection threshold
% parm.Radius_gray = [-2 2]; Radius to remove noise in gray matter image
% (Brain model parameters)
% parm.Radius_fill = [6];    Cortex fill radius
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- Setting for Output file  
% [relative path from 'proj_root']
head_parm.head_file = [];

% --- Setting for MRI input file  
% (Absolute path)
head_parm.analyze_file = 'Subject.nii';

% --- Setting for Scalp input file [There are 2 cases]
% 1.  head_parm.face_file     : face file made by vbmeg
% 2.  head_parm.fs_scalp_file : FreeSurfer Scalp ('outer_skin_surface.asc')

% (Absolute path) 
% head_parm.face_file = [];
head_parm.fs_scalp_file = 'bem/outer_skin_surface.asc';

% --- Setting for CSF input files [There are 3 cases]
% 1. FreeSurfer file Case
% 2. Segment file Case
% 3. Curry file Case
%    We recommend to use 'freesurf_file' + 'gray_file' + 'brain_file'

% Relative path from 'proj_root'
head_parm.brain_file = 'Subject.brain.mat';

% (Absolute path) 
head_parm.freesurf_file = 'bem/inner_skull_surface.asc';
head_parm.gray_file  = 'c1Subject.nii';
%   head_parm.curry_file = [];


% Number of surface
% Default is 3 shell model
head_parm.Nsurf = 3;
head_parm.Nvertex = [2000];

%%% --- Advanced Optional Parameters
%%%     Usually, there is no need to change the following parameters
%%%     In the case where the result is not good, you can try again 
%%%     by changing the following parameters

% Set Default Radius parameters
head_parm.Radius_fs  = [4 -4]; 
head_parm.Radius_csf = [6 6 -7 ] ; 
head_parm.Radius_scalp = 4; 
head_parm.Radius_skull = 2; 
head_parm.Skull_ratio  = 0.5;

head_parm.Radius     = [4 -4 ] ; 
head_parm.Radius_final = [4 -4];

head_parm.Radius_fill = [6];     
head_parm.Radius_gray = [-2 2];  
head_parm.Glevel      = [0.8];  

head_parm.Nloop  = 200;  

head_parm.Nlast_csf   = 10 ; 
head_parm.Nlast_scalp = 0 ;  
head_parm.Nlast_skull = 0 ;  


% Scalp_mode
head_parm.Scalp_mode = 0; 

% subsampling size for mask image [mm]
if vb_matlab_version > 6,
	head_parm.vstep = 1; 
else
	head_parm.vstep = 2; 
end

