function [extra_brain_parm]  = vb_set_extra_brain_parm
% Parameter set to add extra dipole to brain for artifact removal
%  [extra_brain_parm]  = vb_set_extra_brain_parm
%  extra_brain_parm : parameter structure with following fields
%
% --- Parameter for extra dipole
%   .extra_key : area key name for extra dipole index
%   .act_ratio : act ratio between fMRI and extra dipole
% --- Input file
%   Original brain file
%   .brain_file
%   .area_file
%   .act_file
% --- Output file
%   New brain file in which extra dipole positions are added
%   .new_brainfile 
%   .new_area_file 
%   .new_act_file  
%
% 2007-2-25 Masa-aki Sato
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Standard parameters
%

extra_brain_parm.extra_key = 'extra';
extra_brain_parm.act_ratio = 1;

%
% --- Input file (Relative path from proj_root)
%
extra_brain_parm.brain_file  = [ 'Retino_TY.brain.mat' ];
extra_brain_parm.area_file   = [ 'Retino_TY.area.mat'];
extra_brain_parm.act_file    = [ 'Retino_TY.act.mat'];

%
% --- Output file (Relative path from proj_root)
%
extra_brain_parm.new_brainfile = ['retino_test.brain.mat'];
extra_brain_parm.new_areafile  = ['retino_test.area.mat'];
extra_brain_parm.new_actfile   = ['retino_test.act.mat'];
