function [extra_basis_parm]  = vb_set_extra_basis_parm
% Parameter set to add extra dipole leadfield to basis for artifact removal
%  [extra_basis_parm]  = vb_set_extra_basis_parm
%  extra_basis_parm : parameter structure with following fields
% --- Parameter for extra dipole
%   .extra_key : area key name for extra dipole index
%
% --- Input file
%   Original basis file
%   .basis_file
%   New brain file in which extra dipole positions are added
%   .new_brainfile 
%   .new_area_file 
%
% --- Output file
%   New basis file in which extra dipole leadfield are added
%   .new_basisfile 
%
% 2007-2-25 Masa-aki Sato
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Standard parameters
%

extra_basis_parm.extra_key = 'extra';

%
% --- Input file (Relative path from proj_root)
%

% original basisfile
extra_basis_parm.basis_file  = [ 'Retino_TY_meg.basis.mat'];

% brainfile include extra dipoles 
extra_basis_parm.new_brainfile = ['retino_test.brain.mat'];
extra_basis_parm.new_areafile  = ['retino_test.area.mat'];

%
% --- Output file (Relative path from proj_root)
%

extra_basis_parm.new_basisfile = ['retino_test.basis.mat'];
