function [current_parm] = vb_set_current_parm()
% Parameter setting of "current_parm" --- sample file
%  [current_parm] = vb_set_current_parm;
%  
% 2006/09/20 ver 0.5 by M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Standard parameters
%

% Input file  : Result of VBMEG estimation
%               (relative path from proj_root)
current_parm.bayesfile = []; % .bayes.mat

% Output file : Estimated current file
%               (relative path from proj_root)
current_parm.currfile = []; % .curr.mat

% Flag for current average 
current_parm.trial_average = ON;
% ON : Average current over all sessions.
% OFF: Current for each session. 

% Time points where currents are calculated. 
% For example, 
% tsubsmpl = [200:300], means currents are calculated from t=200 to t=300
% tsubsmpl = [1:5:100], means currents are calculated at every 5 sample
% tsubsmpl = [] --> whole time period is calculated
current_parm.tsubsmpl = [];

% If current for each session is calculated (trial_average = OFF)
% and data size exceed memory size,  specify jactdir to save current 
% file for each trial.
current_parm.jactdir = []; % (relative path from currfile)

%
% --- Advanced parameters
%  Do not change, unless you understand the meaning of the parameters!!
%

% If current of specified area is needed, specify area_key
current_parm.areafile = []; % .area.mat
current_parm.area_key = [];

% Flag for how to calculate representative time course from the set of
%   time courses estimated on the vertices in the specified area.
% 0 : Current time courses for all vertices are
%       saved. N=size(J,1) is the number of vertices.
% 1 : Average of time courses (N=1).
% 2 : SVD is applied and the first principal component is extracted (N=1).
current_parm.flag = 0;

% overlap_mode 
%   = 0 : current is averaged over overlapped time window
%   = 1 : current is not averaged for overlapped window
%         current time series of each time windows 
%         are concatenated sequentially for spectral analysis
current_parm.overlap_mode = 0;
