function [bayes_parm] = vb_set_bayes_parm_test(proj_root)
% Parameter setting of "bayes_parm" --- sample file
%  bayes_parm = vb_set_bayes_parm_test(proj_root)
%
% proj_root  : Root directory of your data files.
%              All file names should be relative path from proj_root.
% bayes_parm : set of estimation parameters
%              See help of vb_set_bayes_parm for the meaning of each fields
%  You should copy this file to your local directory 
%     and modify according to your environment.
%  Alternately, you can make 'bayes_parm' parameter file using GUI.
% 
% 2006/09/20 ver 0.5 by M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Set default parameter 
bayes_parm = vb_set_bayes_default_parameters;

% Root directory of data files
if ~exist('proj_root', 'var')
	error('Input argument proj_root is not given!!')
end

% Data file
MRI_ID = '100009d';
LF_ID  = 'pick1';
MEG_ID = 'retino_150_200_250_300_SN20';

% --- Input file (relative path from proj_root)
bayes_parm.brainfile = [  MRI_ID  '.brain.mat' ];
bayes_parm.areafile  = [  MRI_ID  '.area.mat'  ];
bayes_parm.actfile   = [  MRI_ID  '.act.mat'   ];
bayes_parm.megfile   = { [MEG_ID  '.meg.mat' ] };
bayes_parm.basisfile = { [MRI_ID '_' LF_ID  '.basis.mat'] };

% --- Output file(relative path from proj_root)
bayes_parm.bayesfile = 'result/test.bayes.mat'

% --- Specify current area and fMRI activity
bayes_parm.area_key  = 'focal_all';
bayes_parm.act_key   = 'focal_all';

% --- Specify time window by sample numbar
bayes_parm.twin_meg  = [151 450]; % Time window for analysis
bayes_parm.Tperiod   = 100; % Time period for current estimation 
bayes_parm.Tnext     = 50;  % Time step for next period

% --- Soft normal constraint flag
bayes_parm.soft_mode = 0;	% = 1: Soft normal constraint

% --- Estimation model 
bayes_parm.forward_model    = 'focal';  % 'focal' or 'focal+global'
bayes_parm.noise_estimation_model = 1;  % 1, ..., 5

% --- Possible noise_estimation_model
% 'COVARIANCE NOISE' : forward_model = 'focal' or 'focal+global'
%        sx0 = pretriger noise
%        current baseline estimation together with sensor noise estimation
% = 1 :  update_sx = ON,  update_v = OFF  - Default for 'focal'
% = 2 :  update_sx = OFF, update_v = OFF  (NO UPDATE)
%
% 'ISOTROPIC NOISE'  : forward_model = 'focal+global'
%        sx0 = estimated noise with current baseline
%        current baseline estimation together with sensor noise estimation
% = 3 :  update_sx = ON,  update_v = ON   - Default for 'focal+global'
% = 4 :  update_sx = ON,  update_v = OFF  (NO GLOBAL UPDATE)
% = 5 :  update_sx = OFF, update_v = OFF  (NO UPDATE)
%
% --- If sensor noise can be reliably estimated by MEG sensor noise file
%     following setting can be used
%
% bayes_parm.megnoisefile   = []; % MEG sensor noise file
%
% 'FIXED NOISE'      : forward_model = 'focal+global'
%        sx0 = pretriger noise
%        current baseline estimation  with fixed sensor noise
% = 6 :  update_sx = OFF, update_v = ON
% = 7 :  update_sx = OFF, update_v = OFF  (NO UPDATE)

%%% If you want to use parameters different from defaults, 
%%% please modify following lines

%% --- fMRI prior setting
% bayes_parm.a0_act  = []; % If a0_act = [], it is automatically estimated
% bayes_parm.Ta0	 = 0;  % Reliability of fMRI information
% bayes_parm.Ta0_act = 0;  % Reliability of fMRI information

%% --- Spatial smoothing radius
% bayes_parm.Rfilt = 6e-3; % [m]

%% --- Iteration number
% bayes_parm.Npre_train = 750;
% bayes_parm.Ntrain     = 1000;

%% When noise estimation period is different from Pre-trigger period:
% --- Noise estimation time window
% bayes_parm.twin_noise  = [1, 300];	% specify sample index 
% --- Baseline activity estimation time window
% bayes_parm.twin_global = bayes_parm.twin_noise;

%% 
%% --- Following settings should be modified by advanced user ---
%%

%
%  Advanced parameters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% bayes_parm.skip   = 50;

%% --- Prior setting
% bayes_parm.a0     = 1;
% bayes_parm.v0     = 0.01; 
% bayes_parm.Tv0    = 0; 

%% ---  Global window (optional)
% bayes_parm.basisfile_global = bayes_parm.basisfile;
% bayes_parm.area_key_global  = ['Cortex'];
% bayes_parm.Rfilt_global  = 0;
% bayes_parm.reduce_global = 1;

%% ---  Soft normal constraint (optional)
% bayes_parm.tan_var = 1 ;
% bayes_parm.var_max = 1/sqrt(2) ;

%% ---  Flag
% bayes_parm.patch_norm      = ON;
% bayes_parm.trial_average   = OFF; 
% bayes_parm.cont_pr         = OFF; 
% bayes_parm.temporal_filter = OFF;
% bayes_parm.expand_spatial_filter = ON;     
% bayes_parm.variance_orientation  = OFF;  
% bayes_parm.remove_crossed_area   = ON;

%% ---  Optinal parameters 
% bayes_parm.reduce = 1;
% bayes_parm.cosval = cos(pi);
% bayes_parm.Fdmin = 1e-50;
% bayes_parm.a_min = 1e-6;
% bayes_parm.a_max = 1e6;
% bayes_parm.noise_reg = 0.1;

%% 
%% --- Do not modify the following
%%

%
% Noise estimation model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bayes_parm = vb_set_noise_estimation_model(bayes_parm, proj_root);
