function bayes_parm = vb_set_bayes_parm(proj_root)
% Parameter setting of "bayes_parm" --- sample file
%  bayes_parm = vb_set_bayes_parm(proj_root)
%  
%  You should copy 'vb_set_bayes_parm_test.m' to your local directory 
%     and modify according to your environment.
%  Alternately, you can make 'bayes_parm' parameter file using GUI.
%
% ------- Summary of bayes_parm --------
% proj_root : Root directory of your data files.
%             All file names should be relative path from proj_root.
% 
% Fields of 'bayes_parm'
%
% ***
% *** Basic Parameters
% ***
% ******************************
% - .megfile (.meg.mat)
%     MEG data file to be analyzed. This is given by cell array of strings.
%    e.g. megfile = {'SESSION1.meg.mat','SESSION2.meg.mat'}
%
% - .basisfile (.basis.mat)
%     Lead field file for the high resolution model.
%    e.g. megfile = {'SESSION1.basis.mat','SESSION2.basis.mat'}
%
% - .brainfile (.brain.mat)
%     Brain file. 
%
% - .bayesfile (.bayes.mat)
%     Result file. Estimated parameters will be saved into this file. 
%
% - .actfile (.act.mat)
%    Activity map file. 
%
% - .areafile (.area.mat)
%    Area file. 
%
% - .act_key
%    ID of an activity map in .actfile. The specified activity map is 
%   used as the prior information to VB variance estimation.
%
% - .area_key
%    ID of an area in .areafile. Possible (focal) dipoles location are 
%   restricted to the specified area. 
%
% - .twin_meg
%    Time window of meg data in .megfile used for analysis. This window 
%   is covered by several small time windows specfied by .Tperiod and
%   .Tnext. It is specified by the start and end of the sampling frame, 
%   not by the actual measurement time. 
%   e.g. twin_meg = [1 600]  
%
% - .Tperiod
%    Size of the small time windows. Its unit is the number of the
%   sampling frames. .Tperiod and .Tnext mentioned below determine 
%   small time windows for analysis.
%   
% - .Tnext
%   Moving steps of the small time window. If 100 sampling frames
%   are covered by 19 small time windows with the size 10 frames,
%   this parameter should be set to 5 (5x(19-1)+10=100). %
%
%   e.g. Tperiod = 100, Tnext = 50  
%               --> [1 100; 51 150; 101 200;...]
%   e.g. Tperiod = [100 100 100], Tnext = [1 51 101] 
%               --> [1 100; 51 150; 101 200;]
%
% - .soft_mode = 0;	% = 1: Soft normal constraint
%    Soft normal constraint flag
%
% *** 
% *** Estimation Model Parameters 
% ***
% ********************************
%   Specify estimation model by forward_model & noise_estimation_model
%
% - .forward_model
%   -- 'focal' 
%   -- 'focal+global' 
%
% - .noise_estimation_model
%   How to estimate 
%       sensor observation noise & brain background baseline activity
%   
% *** The following fields are automatically set by noise_estimation_model
%     You can change the time window for estimation
%
% - .twin_noise
%   Time window (start and end) used for estimation 
%   of the covariance of the observation noise
%
% - .twin_global
%   Time window (start and end) used for estimation 
%   of the baseline current activity
%
% - megnoisefile (.meg.mat)
%   MEG data file for estimating the variance and covariance of 
%   the observation noise.
%
% *** Do not modify the following fields directory
%
% - .noise_model
%   Specifying noise model. 
%   -- 1 spherical, same noise variance for all sensors
%   -- 2 ellipsoidal, different noise variances but independent
%   -- 3 full covariance, most general noise model 
%
%
% - .update_sx
%   Specifying how to estimate the variance of the observation
%   noise. 
%   -- 0 Estimated from MEG data specified by
%        bayes_parm.megnoisefile and bayes_parm.meg_noise. 
%   -- 1 Estimated simultaneously with the variances of 'sparse'
%        model. 
%
% - .update_v
%   Specifying how to estimate the variance parameter of the 'iso'
%   model.
%   -- 0 Estimated from MEG data specified by
%        bayes_parm.megbackfile and bayes_parm.meg_back. 
%   -- 1 Estimated simultaneously with the variances of the high
%        resolution model.
% 
% ***
% *** Advanced parameters
% ***
% **********************************
%
% *** Global window  (default value)
% - .reduce_global (1)
%    Rate to reduce the number of vertex points in global window. 
%    This value must range from 0 to 1. 
% - .basisfile_global (.megfile)
% - .area_key_global  ('Cortex')
% - .Rfilt_global     (0)
%   Radius (mm) of the smoothing filter along with the cortical
%   surface for the low resolution model. 6mm (=6e-3) or 9mm is
%   recommended. 
%
% *** Prior and VB estimation parameters (default value)
% - .a0 (1)
%   Prior variance value corresponding to the minimum activity. 
% - .a0_act (1000) 
%   Prior variance value corresponding to the maximum activity. 
% - .Ta0 (0)
%   The confidence parameter of the prior variance for the high
%   resolution estimation. This value is interpreted as a ratio to
%   the sampling data number. That is, if it is set to 1, the prior
%   is weighted equal to the estimated value based on the
%   likelihood. 
% - .Tv0 (0)
%   The confidence parameter of the prior variance for the low
%   resolution estimation. This value is interpreted as a ratio to
%   the sampling data number as in the case of bayes_parm.Ta0. 
% - .Ntrain (1000)
%   Total number of parameter updates. 
% - .Npre_train (750)
%   Number of parameter updates in the first stage by using VB-update rule. 
% - .skip (10)
%   Number of iterations to calculate the free energy. 
%
% *** Optional parameters (default value)
% - .cont_pr (OFF)
%   Flag whether initializing the prior parameters using estimated parameters
%   of previous time window
% - .temporal_filter (OFF)
%   Flag whether applying temporal smoothing filter to MEG data. 
% - .trial_average   (OFF) 
%   Flag wheter applying trial average to MEG data.
% - .expand_spatial_filter  (ON)     
%   Flag whether using expanding spatial filter 
% - .variance_orientation   (OFF) 
%   Flag whether variance parameters have orientation
%
% - .cosval (-1)
%   Orientation constraint for neighbour dipoles. A recommended
%   value is 1 (=cos(pi)), which means no constraint. 
% - .Rfilt (6e-3)
%   Radius (m) of the smoothing filter along with the cortical
%   surface. 6mm (=6e-3) or 9mm is recommended. 
% - .noise_reg (0.1)
%   Regularization parameter for the normalized covariance matrix
%   of the additive noise. This value should be determined
%   considering that the mean of the diagonal part of the
%   normalized covariance matrix is 1.
% - .reduce (1)
%    Rate to reduce the number of vertex points. This value must 
%   range from 0 to 1. 
% - .Fdmin (1e-50)
%   Criterion of convergence of the VB algorithm. 
% - .a_min (1e-6)
%   Minimum value of alpha. 
% - .a_max (1e6)
%   Maximum value of alpha. 
%
%
% ---------------------------------------------------------------
%
% ***
% *** File format of resultfile (.bayes.mat)
% ***
% ************************************************
% - bayes_parm
%   Input parameters 
% - Model
%   Estimated variance parameters 
% - Cov
%   Additive noise covariance. 
% - Info
%   Convergence information such as FE, Ev and Err ...
% - vb_parm 
%   Parameters used in VB estimation
%--- 
% 
% 2006/09/20 ver 0.5 by M. Sato
% 2008-11-05 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Set default parameter
bayes_parm = vb_set_bayes_default_parameters; 

% If 'proj_root' is not given, only default parameters are set
if ~exist('proj_root', 'var'), 	return; end;

% --- Input file(relative path from proj_root)
bayes_parm.brainfile = [];
bayes_parm.areafile  = [];
bayes_parm.actfile   = [];
bayes_parm.megfile   = { [] };
bayes_parm.basisfile = { [] };

% --- Output file(relative path from proj_root)
bayes_parm.bayesfile = '';

% --- Specify current area and fMRI activity
bayes_parm.area_key  = 'Cortex';
bayes_parm.act_key   = {'Uniform'};

% --- Specify time window by sample numbar
bayes_parm.twin_meg  = []; % Time window for analysis
bayes_parm.Tperiod   = []; % Time period for current estimation 
bayes_parm.Tnext     = []; % Time step for next period

% --- Soft normal constraint flag
bayes_parm.soft_mode = 0;	% = 1: Soft normal constraint

% --- Estimation model 
bayes_parm.forward_model    = 'focal';  % 'focal' or 'focal+global'
bayes_parm.noise_estimation_model = 1;  % 1, ..., 5

% Extra dipole parameters
bayes_parm.extra = []; 

%
% Noise estimation model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bayes_parm = vb_set_noise_estimation_model(bayes_parm, proj_root);
