function basis_parm = vb_set_basis_parm_eeg_test(mode)
% Set parameters for leadfield calculation
% basis_parm = vb_set_basis_parm
%
% 2006/09/20 ver 0.5 by M. Sato
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Standard parameters (relative path from proj_root)
%
brain_id = 'SK';
data_id  = 'SK_low_epoch';

basis_parm.brain_file = [brain_id 'brain' '.brain.mat' ];
basis_parm.area_file  = [brain_id 'brain' '.area.mat'  ];

basis_parm.meg_file   = ['eeg/' data_id '.info.mat'];

% Head files for EEG 3-shell model
basis_parm.head_file  = ...
	{'SK_csf_2000.head.mat';
	 'SK_skull_2000.head.mat';
	 'SK_scalp_2000.head.mat'};

%
% --- Output file(relative path from proj_root)
%
if exist('mode','var') && mode==0
	basis_parm.basis_file = [brain_id '_' data_id '_sph' '.basis.mat'];
else
	basis_parm.basis_file = [brain_id '_' data_id '.basis.mat'];
end

global vbmeg_inst;
const = vbmeg_inst.const;

% MEG/EEG device name
basis_parm.device = 'BIOSEMI';

% BEM mode definition
% const.BASIS_MEG_SPHERE    = 0; %  MEG Sphere model (Sarvas)
% const.BASIS_MEG_BEM	    = 1; %  MEG 1-shell BEM
% const.BASIS_MEG_HARMONICS = 2; %  MEG Spherical harmonics expansion
% const.BASIS_EEG_SPHERE    = 3; %  EEG 3-shell Sphere model
% const.BASIS_EEG_BEM	    = 4; %  EEG 3-shell BEM

if exist('mode','var') && mode==0
	basis_parm.bem_mode   = const.BASIS_EEG_SPHERE;
else
	basis_parm.bem_mode   = const.BASIS_EEG_BEM;
end

% Current degree of freedom (Basis_mode)
% const.CURRENT_NORMAL  = 1;  %  normal to cortex
% const.CURRENT_TANGENT = 2;  %  tangent vectors
% const.CURRENT_3D	    = 3;  %  x, y, z -direction

basis_parm.Basis_mode = const.CURRENT_NORMAL;

% Average mode for normal direction
% const.NORMAL_ADJACENT_MEAN  = 0;  % ˡʿ
% const.NORMAL_NEIGHBOR_MEAN  = 1;  % BVǾǥ˵ˡʿ

basis_parm.normal_mode = const.NORMAL_ADJACENT_MEAN;
%basis_parm.normal_mode = const.NORMAL_NEIGHBOR_MEAN;

%
% --- Advanced parameters
%  Do not change, unless you understand the meaning of the parameters!!
%

basis_parm.area_key = [];

% coordinate value of the head center.(1x3 on SPM_Right_m)
basis_parm.Vcenter = [];

% Order of spherical harmonics function
basis_parm.func_order = 35;
% Conductivity from innermost to outermost
basis_parm.sigma  = [ 0.62  0.03  0.62 ];
% Relative radius of sphere from innermost to outermost
basis_parm.radius = [ 0.87  0.92   1.0 ];

basis_parm.Recalc = OFF;
