function [meg_parm] = vb_meg_parm_set_measurement(meg_parm, Measurement, device)
% This function sets meg_parm to measurement information.
% [USAGE]
%    [meg_parm] = vb_meg_parm_set_measurement(<meg_parm>, <Measurement>, <device>);
% [IN]
%       meg_parm : this meg_parm is added measurement fields.
%    Measurement : Hardware type
%                  = 'MEG' : MEG
%                  = 'EEG' : EEG
%         device : Device type
%                  = 'YOKOGAWA' : yokogawa
%                  = 'SBI'      : shimadzu
%                  = 'BIOSEMI'  : biosemi
%                  = 'BRAINAMP' : brainamp
% [OUT]
%    meg_parm :  meg_parm is added measurement fields.
% [NOTE]
%    Measurement and device string are used in job_meg.
%    When you decide the specification of the string, think with job_meg.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('meg_parm', 'var'), error('meg_parm is a required parameter.'); end
if ~exist('Measurement', 'var')
    error('Measurement is a required parameter.');
end
if ~exist('device', 'var')
    error('device is a required parameter.');
end

%
% --- Main Procedure
%
if isempty(meg_parm)
    meg_parm = struct;
end
meg_parm.Measurement = Measurement;
meg_parm.device      = device;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive meg_parm.');
end
