function vb_plot_slice_head(headfile,analyzefile,brainfile)
% Plot head shape and cortex surface on MRI slice
%  vb_plot_slice_head(headfile,analyzefile,brainfile)
% --- Input
% headfile{n} : cell array of head file(*.head.mat)
% analyzefile : analyze file(*.hdr)
%   brainfile : brain file(*.brain.mat)
%
% 2006/10/20 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Mtype = { 'y-' , 'r-' , 'c-' , 'g-' , 'w-', 'm.'};
dmax  = 5;

% Load 3D MRI image to analyze_right_hand coordinate
[B, Vdim, Vsize] = vb_load_analyze_to_right(analyzefile);

% # of subplot
Nfigx = [2, 2] ;
Nfigz = [2, 2] ;
% slice number to cut
xindx = fix(Vdim(1)* [0.2:0.2:0.8]);
zindx = fix(Vdim(3)* [0.4:0.1:0.7]);
%xindx = [50 80 120 150 ];   
%zindx = [120 150 170 200];

% plot analyze data
h1 = vb_plot_slice_surf( B, [], [], xindx, 'x', Nfigx, Mtype{6}, dmax, 0);
h2 = vb_plot_slice_surf( B, [], [], zindx, 'z', Nfigz, Mtype{6}, dmax, 1);

% 
% --- Plot cortex surface
%
if exist('brainfile','var') & ~isempty(brainfile)
    dz = 5;
    Msize  = 2;
    V = vb_load_cortex(brainfile, 'subj');
   
    V = vb_spm_right_to_analyze_right( V, Vdim, Vsize);
    figure(h1);
    %vb_plot_slice_surf([], V, F.F3, xindx, 'x', Nfigx, Mtype{6}, dmax, 0);
    for k=1:length(xindx)
        subplot(Nfigx(1), Nfigx(2), k);
        vb_plot_vertex(V, 'x', xindx(k), dz, Msize, Mtype{6}, 0);
    end
    figure(h2);
    for k=1:length(zindx)
        subplot(Nfigz(1), Nfigz(2), k);
        vb_plot_vertex(V, 'z', zindx(k), dz, Msize, Mtype{6}, 1);
    end
%    vb_plot_slice_surf([], V, F.F3, zindx, 'z', Nfigz, Mtype{6}, dmax, 1);
end

% 
% --- Overwrite Head surface
%

%    headfiles{1} = ['csf.head.mat'];    % ǾԿ
%    headfiles{2} = ['skull.head.mat'];  % Ƭ?
%    headfiles{3} = ['scalp.head.mat'];  % Ƭ?

if ~iscell(headfile), headfile = {headfile}; end;

dmax  = 10; % search distance from cut slice
Nfile = length(headfile);

for n=1:Nfile
    if isempty(headfile{n}), continue; end;
    load(headfile{n},'Vhead','Fhead')
    Vhead = vb_spm_right_to_analyze_right( Vhead, Vdim, Vsize);
    figure(h1);
    vb_plot_slice_surf( [], Vhead, Fhead, xindx, 'x', Nfigx, Mtype{n},dmax,0);
    figure(h2);
    vb_plot_slice_surf( [], Vhead, Fhead, zindx, 'z', Nfigz, Mtype{n},dmax,1);
end
