function	vb_plot_compare_brain(analyzefile, brainfile1, brainfile2)
% Plot two brain model on MRI slice for comparison
%  vb_plot_compare_brain(analyzefile, brainfile1, brainfile2)
% --- Input
% analyzefile
% brainfile1
% brainfile2
%
% 2006/10/19 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
%---- Load analyze left-handed image & flip to right-handed image
%
[B, Vdim, Vsize] = vb_load_analyze_to_right(analyzefile);

%
%---- Load vertex coordinate from brain file 
%

[V1, F1] = vb_load_cortex(brainfile1);
F1 = F1.F3;

[V2, F2] = vb_load_cortex(brainfile2);
F2 = F2.F3;

% Transform vertex coordinate to analyze right-handed coordinate
V1 = vb_spm_right_to_analyze_right(V1,Vdim,Vsize);
V2 = vb_spm_right_to_analyze_right(V2,Vdim,Vsize);

%
%---- Cortex on the slice image
%     

% 饤ɽ Z-ɸꥹ
vcut  = 'z';
zindx = [130:10:200];

Msize   = 1;		% marker size
Mtype1  = 'y-';		% marker type
Mtype2  = 'c-';		% marker type
dz      = 5;		% search radius for intersection triangle
xymode  = 1;

% subplot  
NX   = 2;
NY   = 2;
Nfig = length(zindx);
nfig = NX*NY;

for n= 1:Nfig
	if nfig==NX*NY, 
		figure; nfig=1;
	else
		nfig=nfig+1;
	end;
	
	subplot(NY,NX,nfig);

	vb_plot_3d_image(B, zindx(n), vcut, xymode);
	
	hold on
	vb_plot_cross_section(V1,F1,zindx(n),vcut,dz,Msize,Mtype1,xymode);
	vb_plot_cross_section(V2,F2,zindx(n),vcut,dz,Msize,Mtype2,xymode);
	title(['z-slice (' num2str(zindx(n),3) ')'])
	colormap(gray);
end

return
