function	h = vb_plot_2d_image(B2,mode)
% Plot 2D image 
%  h = vb_plot_2d_image(B, mode)
%
% B : 2D-image [NBx, NBy]
% --- Optional input
% mode : 2D plot mode for X-Y 
%      = 0   : plot without transpose
%      = 1   : plot by transposing 2D-image matrix
%
% written by M. Sato  2005-8-1
% Modified by M Sato  2007-3-16
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('mode','var'), mode = 0; end;

% Image dimension
[NX ,NY] = size(B2);

X = 1:NX;
Y = 1:NY;

if mode==0
	% Flip X-Y
	% Index color -> True color
	B3 = repmat(B2',[1 1 3]);

	h = image(X, Y, B3, 'CDataMapping','scaled');
	set(gca,'YDir','normal','XLimMode','manual','YLimMode','manual');
else
	% Index color -> True color
	B3 = repmat(B2,[1 1 3]); 
	
	h = image(Y, X, B3, 'CDataMapping','scaled');
end

colormap('gray');
axis equal
axis tight
