function	[XP,YP,XP1,YP1,XP2,YP2,XP3,YP3,NN] = ...
              vb_get_cross_section(V,F,Z0,vdim,dmax,xymode)
% plot cross section of surface on the slice
%   [X,Y] = vb_get_cross_section(V,F,Z0,vdim,dmax,xymode)
%   [X,Y,X1,Y1,X2,Y2,X3,Y3] = vb_get_cross_section(V,F,Z0,vdim,dmax,xymode)
% --- Input
% V  : voxcel coordinate of the surface [Nvertex x 3]
% F  : patch index of the surface       [Npatch  x 3]
% Z0 : slice index for plot             [1 x 1]
% --- Optional Input
% vdim  : slice cut direction
%       = 'x' : Sagittal cut : Y-Z plane
%       = 'y' : Coronal cut : X-Z plane
%       = 'z' : Transverse (Axial) cut : X-Y plane
% dmax  : search distance from cut slice (= 5)
% xymode  : 2D plot mode for X-Y (= 0)
%       = 0   : plot without transpose
%       = 1   : plot by transposing 2D-image matrix
% --- Output
% X  : List of two X coordinate for line segment : [2 x NP]
% Y  : List of one Y coordinate for line segment : [2 x NP]
%  For most cases X & Y are enough for cross section plot
%  In special cases following lists of lines are given
% X1 : List of one X coordinate for points : [1 x NP]
% Y1 : List of two Y coordinate for points : [1 x NP]
% X2 : List of 4 X coordinate for line segment : [4 x NP]
% Y2 : List of 4 Y coordinate for line segment : [4 x NP]
% X3 : List of 6 X coordinate for line segment : [6 x NP]
% Y3 : List of 6 Y coordinate for line segment : [6 x NP]
%
% --- Calculation of intersection point at Z = 0
% Line : V1 = [X1 Y1 Z1] to V2 = [X2 Y2 Z2]
%      : V  = (V1 - V2) * t + V2 
% z = 0 : 
% x = (X1*Z2 - X2*Z1)/(Z2 - Z1)
% y = (Y1*Z2 - Y2*Z1)/(Z2 - Z1)
%
% 2007-4-5 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('vdim','var'),  vdim = 'z'; end;
if ~exist('dmax','var'),  dmax  = 5; end;
if ~exist('xymode','var'),  xymode  = 0; end;

switch	vdim
case	'x',
	% 'SAG' : Sagittal cut : Y-Z plane
	ax = 2;
	ay = 3;
	az = 1;
case	'y',
	% 'COR' : Coronal cut : X-Z plane
	ax = 1;
	ay = 3;
	az = 2;
case	'z',
	% 'TRN' : Transverse (Axial) cut : X-Y plane
	ax = 1;
	ay = 2;
	az = 3;
end

switch	xymode
case	0,
	X  = V(:,ax);
	Y  = V(:,ay);
case	1,
	X  = V(:,ay);
	Y  = V(:,ax);
end

% slice axis coordinate 
Z = V(:,az) - Z0;

% Flag indicate upper & lower side of slice within dmax
Uix = (Z >= 0 & Z <= dmax);	% flag of upper side of slice
Lix = (Z <  0 & Z >= -dmax);% flag of lower side of slice

% Flag for patch index
FUix = Uix(F); 
FLix = Lix(F); 

% Patch include both upper and lower side of slice within dmax
Flist = find(sum(FUix,2) > 0 & sum(FLix,2) > 0);
Nlist = length(Flist);

XP  = zeros(2,Nlist);
YP  = zeros(2,Nlist);
XP1 = [];
YP1 = [];
XP2 = [];
YP2 = [];
XP3 = [];
YP3 = [];

NN = [];
m  = 0;
m0 = 0;
m1 = 0;
m2 = 0;
m3 = 0;

for j=1:Nlist
	n  = Flist(j);	% patch id
	id = F(n,:);	% vertex index of patch
	up = FUix(n,:);	% Upper side flag of each vertex in the n-th patch
	dn = FLix(n,:);	% Lower side flag of each vertex in the n-th patch
	x  = [];		% x-coordinate to intersect the slice Z = 0
	y  = [];		% y-coordinate to intersect the slice Z = 0
	
	% Check two vertex of edge are in opposite side
	% : Check edge intersect the slice Z = 0
	%   and add intersection points to the list
	if (up(1)*dn(2) + up(2)*dn(1)) > 0,
		% Two vertex points of edge
		X1 = X(id(1));	X2 = X(id(2));
		Y1 = Y(id(1));	Y2 = Y(id(2));
		Z1 = Z(id(1));	Z2 = Z(id(2));
		
		if Z1 == Z2,
			% line is on the Z = 0 slice
			x = [x; X1; X2];
			y = [y; Y1; Y2];
		else
			% Intersection point at Z = 0
			x = [x; (X1*Z2 - X2*Z1)/(Z2 - Z1)];
			y = [y; (Y1*Z2 - Y2*Z1)/(Z2 - Z1)];
		end
	end
	
	if (up(2)*dn(3) + up(3)*dn(2)) > 0,
		% Two vertex points of edge
		X1 = X(id(2));	X2 = X(id(3));
		Y1 = Y(id(2));	Y2 = Y(id(3));
		Z1 = Z(id(2));	Z2 = Z(id(3));
		
		if Z1 == Z2,
			% line is on the Z = 0 slice
			x = [x; X1; X2];
			y = [y; Y1; Y2];
		else
			% Intersection point at Z = 0
			x = [x; (X1*Z2 - X2*Z1)/(Z2 - Z1)];
			y = [y; (Y1*Z2 - Y2*Z1)/(Z2 - Z1)];
		end
	end
	
	if (up(3)*dn(1) + up(1)*dn(3)) > 0,
		% Two vertex points of edge
		X1 = X(id(3));	X2 = X(id(1));
		Y1 = Y(id(3));	Y2 = Y(id(1));
		Z1 = Z(id(3));	Z2 = Z(id(1));
		
		if Z1 == Z2,
			% line is on the Z = 0 slice
			x = [x; X1; X2];
			y = [y; Y1; Y2];
		else
			% Intersection point at Z = 0
			x = [x; (X1*Z2 - X2*Z1)/(Z2 - Z1)];
			y = [y; (Y1*Z2 - Y2*Z1)/(Z2 - Z1)];
		end
	end
	
	NP = length(x);
	
	if NP == 2,
		m = m + 1;
		XP(:,m) = x;
		YP(:,m) = y;
	elseif NP == 1,
		m1 = m1 + 1;
		XP1(:,m1) = x;
		YP1(:,m1) = y;
	elseif NP == 4,
		m2 = m2 + 1;
		XP2(:,m2) = x;
		YP2(:,m2) = y;
	elseif NP == 6,
		m3 = m3 + 1;
		XP3(:,m3) = x;
		YP3(:,m3) = y;
	else
		m0 = m0 + 1;
		NN(m0) = NP;
	end
end

XP = XP(:,1:m);
YP = YP(:,1:m);

XP1 = XP1(:,1:m1);
YP1 = YP1(:,1:m1);

XP2 = XP2(:,1:m2);
YP2 = YP2(:,1:m2);

XP3 = XP3(:,1:m3);
YP3 = YP3(:,1:m3);
