function fig = vb_check_brain_model(proj_root,brain_parm, V, F)
% Plot brain model in 3D & on MRI slice for checking
%  vb_check_brain_model(proj_root,brain_parm, [V], [F])
%
% 2006/10/19 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% Brain file
%
analyzefile = brain_parm.analyze_file;
if isempty(proj_root)
    brainfile   = [brain_parm.brain_file];
else
    brainfile   = [proj_root '/' brain_parm.brain_file];
end

%
%---- Cortex 3D image
%     

%---- Load vertex coordinate from brain file
if ~exist('V', 'var')
    [V, F] = vb_load_cortex(brainfile, 'subj');
end
V = V .* 1000; % [m] to [mm]

% View angle
angle = [45 30; -45 30; -60 30; 60 30];

Nfig  = 4;
NY    = 2;
NX    = 2;
fclr  = [0.8 0.7 0.6];
eclr  = 'none';

light_mode = 1;
max_mode   = 1;

% figure;
% h=subplot(NY,NX,1);
% vb_plot_surf(V, F.F3L, fclr,eclr,light_mode,max_mode)
% view(angle(1,:));
% title('Left brain')
% xlabel('[mm]'); ylabel('[mm]'); zlabel('[mm]');
% vb_axes_add_click_open(h);
% 
% h=subplot(NY,NX,2);
% vb_plot_surf(V, F.F3R, fclr,eclr,light_mode,max_mode)
% view(angle(2,:));
% title('Right brain')
% xlabel('[mm]'); ylabel('[mm]'); zlabel('[mm]');
% vb_axes_add_click_open(h);
% 
% h=subplot(NY,NX,3);
% vb_plot_surf(V, F.F3, fclr,eclr,light_mode,max_mode)
% view(angle(3,:));
% title('Both brain [Left angle]')
% xlabel('[mm]'); ylabel('[mm]'); zlabel('[mm]');
% vb_axes_add_click_open(h);
% 
% h=subplot(NY,NX,4);
% vb_plot_surf(V, F.F3, fclr,eclr,light_mode,max_mode)
% view(angle(4,:));
% title('Both brain [Right angle]')
% xlabel('[mm]'); ylabel('[mm]'); zlabel('[mm]');
% vb_axes_add_click_open(h);

V = V ./ 1000; % [mm] to [m]

%
%---- Cortex on the slice image
%     

%
%---- Load analyze left-handed image 
%     & flip to right-handed image
if ~exist(analyzefile,'file'), 
	fprintf('There is no analyze file: %s\n',analyzefile)
	fprintf('Check of MRI and brain model is skipped\n')
	return
end

[B, Vdim, Vsize] = vb_load_analyze_to_right(analyzefile);

% Transform vertex coordinate to analyze right-handed coordinate
Vana   = vb_spm_right_to_analyze_right(V,Vdim,Vsize);

Msize   = 2;		% marker size
%Mtype   = 'y-';		% marker type
dz      = 5;		% search radius for intersection triangle
vcut    = ['x','y','z'];	% slice cut direction
%indx    = [80 120 130 170 ];	% slice number to cut
indx    = fix([Vdim(1)*0.45 Vdim(2)/2 Vdim(3)*0.5 Vdim(3)*0.7]);% slice number
xymode  = 0;

label   = {'Sagittal cut'; 'Coronal cut'; 'Axial cut'; 'Axial cut'};

Nfig = length(vcut);
NX   = 3;
NY   = 3;

fig = figure;
set(fig, 'Menubar', 'none', 'Name', 'Cortex model on slices.', 'NumberTitle', 'off');
set(fig, 'Units', 'normalized', 'Position', [0.3, 0.2, 0.4, 0.7]);

for n= 1:Nfig
	h=vb_subaxis(NY,NX, n, 'MR', 0.05, 'ML', 0.08, 'MT', 0.05, 'MB', 0.05);
	vdim = vcut(n);
	[strX,strY] = vb_plot_3d_image(B, indx(n), vcut(n), xymode);
	xlabel(strX);
	ylabel(strY);
	
	hold on
    if isempty(F)
    	vb_plot_vertex(Vana, vcut(n), indx(n), dz, Msize, 'y.', xymode);
    else
        vb_plot_cross_section(Vana,F.F3,indx(n),vcut(n),dz,Msize, 'y-',xymode);
    end
	title(label{n})
    vb_axes_add_click_open(h);
end

% Slice index in Z-axis
vcut  = 'z';
zindx = fix(Vdim(3)* [0.3:0.1:0.8]);
%zindx = [140:10:190];

% Number of subplot 
%NX   = 3;
%NY   = 2;
Nfig = length(zindx);

%figure;

for n= 1:Nfig
	h=vb_subaxis(NY,NX,3+n, 'MR', 0.05, 'ML', 0.08, 'MT', 0.1, 'MB', 0.05);
	vb_plot_3d_image(B, zindx(n), vcut, xymode);
	
	hold on
    if isempty(F)
    	vb_plot_vertex(Vana, vcut, zindx(n), dz, Msize, 'y.', xymode);
    else
    	vb_plot_cross_section(Vana,F.F3,zindx(n),vcut,dz,Msize,'y-',xymode);
    end
	title(['z-slice (' num2str(zindx(n),3) ')'])
	colormap(gray);
    vb_axes_add_click_open(h);
end

return
