function [basis, basis_parm] = vb_job_leadfield_meg_sphere(proj_root, basis_parm)
% actual worker function for MEG-SPHERE
% [usage]
%   [basis, basis_parm] = vb_job_leadfield_meg_sphere(proj_root, basis_parm)
% [input]
%    proj_root : <required> project root directory
%   basis_parm : <required> <<struct>>
%              :  data set in which the specification of calculation is defined
% [output]
%   none
% [note]
%   <<prior conditions>>
%     1) proj_root is valid
%     2) basis_parm is commonly valid
% [history]
%   2007-01-26 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
[proj_root, basis_parm] = inner_check_arguments(proj_root, basis_parm);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% pre-processing
[Basis_mode, pick, Qpick, Wsensor, V0, V, xx] = ...
  vb_lf_preprocess(proj_root, basis_parm);

% Change center of coordinate
pick = [pick(:,1)-V0(1), pick(:,2)-V0(2), pick(:,3)-V0(3)];
V    = [   V(:,1)-V0(1),    V(:,2)-V0(2),    V(:,3)-V0(3)];
	
% Calculate current direction according to 'Basis_mode'
[V,xx] = vb_current_vector(V, xx, Basis_mode);

NV      = size(V,1);
Npick   = size(pick,1);

fprintf('--- MEG Sphere model (Sarvas)\n');

BB = zeros(NV , Npick);
	
for i=1:Npick,
	BB(:,i) = vb_sarvas_new(V, xx, pick(i,:), Qpick(i,:) );
end
	
basis = BB * Wsensor';
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [proj_root, basis_parm] = inner_check_arguments(proj_root, basis_parm)
% there is no unique points to check MEG-SPHERE
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
