function [W, valid] = vb_spherical_harmo_W(n, m, F, Itbl, p_z_m, c_s)
% spherical harmonics W
% [usage]
%   [W, valid] = vb_spherical_harmo_W(n, m, F, Itbl, p_z_m, c_s)
% [input]
%       n : index of n-term of legendre
%       m : index of m-term of legendre
%       F : spherical harmonics functions
%    Itbl : index table of n and m for cosine and sine (n x m x 2)
%   p_z_m : [string] plus('+') or zero('0') or minus('-')
%     c_s : [short]  cosine or sine flag : 0(cosine), 1(sine)
% [output]
%       W : calculated W-term
%   valid : validity of this calculation (true or false)
% [note]
%
% [history]
%   2006.06.22 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

W = zeros(size(F,1),1);
valid = true;

if c_s ~= 0 & c_s ~= 1
  disp('c_s is allowed to set 0(cosine) or 1(sine)');
  valid = false;
  return;
end

nn = n-1;

switch  p_z_m
  case  '+'
    a = a_param(n,m,'+');
    mm = m+1;
	W  = vb_get_spherical_harmo(nn,mm,F,Itbl,c_s);
	W  = a * W;

  case  '-'
    a = a_param(n,m,'-');
    mm = m-1;
	W  = vb_get_spherical_harmo(nn,mm,F,Itbl,c_s);
	W  = a * W;
    
  case  '0'
    a = a_param(n,m,'0');
    mm = m;
	W  = vb_get_spherical_harmo(nn,mm,F,Itbl,c_s);
	W  = a * W;
    
  otherwise
end


% func : calculate 'a' value
% [usage]
%   a = a_param( n, m, p_z_m )
% [input]
%       n : index of n-term of legendre
%       m : index of m-term of legendre
%   p_z_m : plus('+') or zero('0') or minus('-')
% [output]
%       a : calculated 'a' value
function a = a_param(n,m,p_z_m)

% Normalized Legendre function case
  switch  p_z_m
    case  '+'
      if m < n-1 & n > 0, 
      	a = (n-m)*(n-m-1)*(2*n+1)/(2*n-1);
      	a = -sqrt(a);
      else
      	a=0; 
      end
    case  '-'
      if n > 0, 
      	a = (m+n)*(m+n-1)*(2*n+1)/(2*n-1);
      	a = sqrt(a);
      else
      	a=0; 
      end
    case  '0'
      if m < n & n > 0, 
      	a = (m+n)*(n-m)*(2*n+1)/(2*n-1);
      	a = sqrt(a);
      else
      	a=0; 
      end
  end
  return;

