function [V, valid] = vb_spherical_harmo_V(n, m, G, Itbl, p_z_m, c_s)
% spherical harmonics V
% [usage]
%   [V, valid] = vb_spherical_harmo_V(n, m, G, Itbl, p_z_m, c_s)
% [input]
%       n : index of n-term of legendre
%       m : index of m-term of legendre
%       G : spherical harmonics functions
%    Itbl : index table of n and m for cosine and sine (n x m x 2)
%   p_z_m : [string] plus('+') or zero('0') or minus('-')
%     c_s : [short]  cosine or sine flag : 0(cosine), 1(sine)
% [output]
%       V : calculated V-term
%   valid : validity of this calculation (true or false)
% [note]
%
% [history]
%   2006.06.22 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

V = zeros(size(G,1),1);
valid = true;

if c_s ~= 0 & c_s ~= 1
  disp('c_s is allowed to set 0(cosine) or 1(sine)');
  valid = false;
  return;
end

nn = n+1;

switch  p_z_m
  case  '+'
    b  = b_param(n,m,'+');
    mm = m+1;
	V  = vb_get_spherical_harmo(nn,mm,G,Itbl,c_s);
	V  = b * V;
	
  case  '-'
    b = b_param(n,m,'-');
    mm = m-1;
	V  = vb_get_spherical_harmo(nn,mm,G,Itbl,c_s);
	V  = b * V;
	
  case  '0'
    b = b_param(n,m,'0');
    mm = m;
	V  = vb_get_spherical_harmo(nn,mm,G,Itbl,c_s);
	V  = b * V;
    
  otherwise
end


% func : calculate 'b' value
% [usage]
%   b = b_param( n, m, p_z_m )
% [input]
%       n : index of n-term of legendre
%       m : index of m-term of legendre
%   p_z_m : plus('+') or zero('0') or minus('-')
% [output]
%       b : calculated 'b' value
function b = b_param(n,m,p_z_m)

% Normalized Legendre function case
  switch  p_z_m
    case  '+'
      	b = (n+m+2)*(n+m+1)*(2*n+1)/(2*n+3);
      	b = -sqrt(b);
    case  '-'
      	b = (n-m+2)*(n-m+1)*(2*n+1)/(2*n+3);
      	b = sqrt(b);
    case  '0'
      	b = (n+m+1)*(n-m+1)*(2*n+1)/(2*n+3);
      	b = -sqrt(b);
  end

