function grad = vb_spherical_grad(X,Q,N,Rmax,f_g)
% spherical gradient dot
% [usage]
%   gradF_Q = vb_spherical_grad( X, Q, N, Rmax, f_g )
% [input]
%      X : coordinates of current (NP x 3)
%      Q : normal vector of current (NP x 3)
%      N : maximum order of spherical function
%   Rmax : radial
%    f_g : target current flag 'f'(F=internal) or 'g'(G=external)
% [output]
%   grad : grad_x * Qx + grad_y * Qy + grad_z * Qz
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

switch f_g
  case  'f'
    grad = vb_spherical_grad_F(X, Q, N, Rmax);
  case  'g'
    grad = vb_spherical_grad_G(X, Q, N, Rmax);
end

return;
