function [idx, r_list] = vb_util_join_head_files(head_files, file_root, ...
  joined_file, layer_tag, calc_mode)
% join plural "single layer" head files and make single head file
% serially-concatenated
% [usage]
%   vb_util_join_head_files(head_files, file_root, joined_file, ...
%     layer_tag, calc_mode)
% [input]
%    head_files : <required> cell array of plural "single layer" head files
%               :   [1 x N]
%     file_root : <optional> root directory for 'head_files' ['.']
%   joined_file : <optional> output file path
%               :   ['(file_root)/joined_head.head.mat']
%     layer_tag : <optional> names of each layer [('CSF', 'Skull', 'Scalp')]
%     calc_mode : <optional> calculation method of radius
%               :   [1] or 2 or 3
%               :  1 : mean distance of each head
%               :  2 : minimum distance of each head
%               :  3 : maximum distance of each head
% [output]
%           idx : index list which is sorted by radius of each layer
%        r_list : radius list which is sorted by their sizes
% [note]
%   stored data are as follows:
%      XXhead : [Npoint x 3]
%       Vhead : [NPoint x 3]
%       Fhead : [NPatch x 3] 
%     Nvertex : [NL x 2]  : start and end index
%      Npatch : [NL x 2]  : start and end index
%   layer_tag : {NL} label of each layer
%
%   !!!NOTICE!!!
%   This function will be removed in a future release.
%   Instead, you can use vb_head_join_files.m
%
% [history]
%   2006-12-04 (Sako) initial version
%   2007-06-14 (Sako) removed unnecessary parameters from head file
%   2010-10-25 (Sako) supported the case that XXhead is empty
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

try
  % --- CHECK ARGUMENTS --- %
  if ~exist('head_files', 'var'), head_files = []; end
  if ~exist('file_root', 'var'), file_root = []; end
  if ~exist('joined_file', 'var'), joined_file = []; end
  if ~exist('layer_tag', 'var'), layer_tag = []; end
  if ~exist('calc_mode', 'var'), calc_mode = []; end
  [head_files, file_root, joined_file, layer_tag, calc_mode] = ...
    inner_check_arguments(head_files, file_root, joined_file, ...
      layer_tag, calc_mode);
  
  % --- MAIN PROCEDURE ------------------------------------------------------- %
  %
  if ~iscell(head_files)
    % require no action
    warning('%s is not cell so it is not required to join', head_files);
    return;
  end

  XXhead = [];
  Vhead = [];
  Fhead = [];
  Nvertex = [];
  Npatch = [];

  % check number of layer
  NL = size(head_files, 2);
  NT = size(layer_tag, 2);

  if ~isequal(NT, NL)
    error('head_files is %d, layer tag is %d.', NL, NT);
  end

  % sort by average radius
  RR = [];
  for n = 1:NL
    load([file_root filesep head_files{n}], 'Vhead');
    RR = [RR vb_util_distance_of_points(Vhead, calc_mode)];
  end

  % sort lists
  [r_list idx] = sort(RR);
  LayerTag = layer_tag(:,idx);
  head_files = head_files(:,idx);

  % re-initialize Vhead
  Vhead = [];
  
  begin_v = 1;
  begin_p = 1;
  Npoint  = 0;
  for n = 1:size(head_files, 2)
    data = load([file_root filesep head_files{n}]);

    % --- 2010-10-25 -->
%     len_v = size(data.XXhead,1);
%     len_p = size(data.Fhead,1);
% 
%     end_v = begin_v + len_v -1;
%     end_p = begin_p + len_p -1;
%     Nvertex = [Nvertex; begin_v end_v];
%     Npatch  = [Npatch;  begin_p end_p];
%     begin_v = end_v + 1;
%     begin_p = end_p + 1;
%   
%     XXhead = [XXhead; data.XXhead];
%     Vhead = [ Vhead; data.Vhead];
%     Fhead = [ Fhead; data.Fhead + Npoint];
    
%     len_v = size(data.XXhead,1);
%     len_p = size(data.Fhead,1);

    len_v = size(vb_headinfo_get_vhead(data),1);
    len_p = size(vb_headinfo_get_fhead(data),1);

    end_v = begin_v + len_v -1;
    end_p = begin_p + len_p -1;
    Nvertex = [Nvertex; begin_v end_v];
    Npatch  = [Npatch;  begin_p end_p];
    begin_v = end_v + 1;
    begin_p = end_p + 1;
  
%     XXhead = [XXhead; data.XXhead];
%     Vhead = [ Vhead; data.Vhead];
%     Fhead = [ Fhead; data.Fhead + Npoint];
    Vhead = [ Vhead; vb_headinfo_get_vhead(data)];
    Fhead = [ Fhead; vb_headinfo_get_fhead(data) + Npoint];
    
    % support empty XXhead
    if isempty(data.XXhead)
      if ~isempty(data.Vhead) && ~isempty(data.Fhead)
        [new_f, new_v, data.XXhead] = vb_out_normal(data.Fhead, data.Vhead);
      else
        if isempty(data.Vhead), warning('Vhead is empty'); end
        if isempty(data.Fhead), warning('Fhead is empty'); end
        warning('XXhead is empty');
      end
    end
    XXhead = [XXhead; vb_headinfo_get_xxhead(data)];
    % <-- 2010-10-25 ---
    
    Npoint = Npoint + len_v;
  end
%   vb_save(joined_file, 'XXhead', 'Vhead', 'Fhead', 'Nvertex', 'Npatch', 'R', 'Rmethod', 'Sigma', 'LayerTag');
  vb_save(joined_file, ...
    'XXhead', 'Vhead', 'Fhead', 'Nvertex', 'Npatch', 'LayerTag');
  %
  % --- END OF MAIN PROCEDURE ------------------------------------------------ %

catch
  rethrow(lasterror);
end

% --- INNER FUNCTIONS ------------------------------------------------------ %
%
% --- inner_check_arguments()
%
function [head_files, file_root, joined_file, layer_tag, calc_mode] = ...
  inner_check_arguments(head_files, file_root, joined_file, ...
    layer_tag, calc_mode)
  
func_ = 'vb_util_join_head_files';
  
if isempty(head_files)
  error('(%s)head_files is a required parameter', func_);
end

if isempty(file_root)
  file_root = '.';
end

if isempty(joined_file)
  joined_file = [file_root filesep 'joined_head.head.mat'];
end
  
if isempty(layer_tag)
  layer_tag = {'CSF' 'Skull' 'Scalp'};
end

if isempty(calc_mode)
  calc_mode = 1;  % mean
end
return;
%
% --- end of inner_check_arguments()
%
% --- INNER FUNCTIONS ------------------------------------------------------ %

%%% END OF FILE %%%
