function Headinfo = vb_headinfo_set_rmethod(headinfo, rmethod)
% setter Headinfo.Rmethod
% [usage]
%   Headinfo = vb_headinfo_set_rmethod(headinfo, rmethod)
% [input]
%   headinfo : <optional> <<struct>> Headinfo
%            :  if it is not specified or is empty, Headinfo will be created
%    rmethod : <optional> value of Rmethod
%            :  if it is not specified or is empty, [] will be set
% [output]
%    Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('rmethod', 'var')    rmethod = []; end;
[Headinfo, rmethod] = inner_check_arguments(headinfo, rmethod);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.Rmethod = rmethod;
if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, rmethod] = inner_check_arguments(headinfo, rmethod)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
