function	[Xout, IX, DD] = vb_map_eeg_to_head(X,Vs,BEM,dx,Np)
% EEG positions are mapped to outermost head surface
%   [Xout, IX, DD] = vb_map_eeg_to_head(X,Vs,BEM,dx,Np)
% X    : sensor coordinate (󥵡ɸ)             [Neeg x 3]
% Vs   : vertex coordinate on the boudary surface (̺ɸ) [Nv x 3]
% BEM.Nvertex   = start & end vertex index for n-th closed surface
%               = [ start_id(1)     end_id(1)     ; 
%                             ...                 ;
%                   start_id(Nsurf) end_id(Nsurf) ]
%                   innermost to outermost 
%               = ƶ̤ĺǥå
%               = [ϥǥå, λǥå]
% dx   : neighbor points are searched within dx (m) from nearest point
% Np   : Np points are searched for each sensor position
% 
% IX   : Vertex index nearest to EEG sensor [Neeg x Np]
% DD   : Distance from EEG sensor to head vertex [Neeg x Np]
% Xout : Nearest head vertex point to EEG sensor;
% 2007-12-25  M. Sato 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

DEBUG = 0;
Rmax  = 1000;

if ~exist('dx','var'), dx = 0.02; end; % 20 mm
if ~exist('Np','var'), Np = 3; end;

%  ѿμ
Neeg = size(X,1);    % # of EEG sensor
IX = zeros(Neeg,Np);
DD = repmat(Rmax,[Neeg,Np]);

% Find outermost head vertex near EEG position

% Vertex index for outermost surface
Nsurf	= size(BEM.Nvertex,1);	% ̤ο
ix_head = BEM.Nvertex(Nsurf,1):BEM.Nvertex(Nsurf,2);

% Vertex for outermost surface
V = Vs(ix_head,:);

if DEBUG==1, V = Vs; end;

for n=1:Neeg
	% 󥵤˺Ǥᤤĺõ
	dd = sqrt((V(:,1)-X(n,1)).^2 + (V(:,2)-X(n,2)).^2 + (V(:,3)-X(n,3)).^2);
	dmin = min(dd);
	
	ix = find( dd <= (dmin + dx));
	Nx = length(ix);
	[d, jx] = sort(dd(ix));
	
	if Nx > Np, 
		jx = jx(1:Np); 
		IX(n,:) = ix_head(ix(jx));
		DD(n,:) = d(1:Np)';
	else
		IX(n,1:Nx) = ix_head(ix(jx));
		DD(n,1:Nx) = d';
	end;
	
end

Xout = Vs(IX(:,1),:);
