function	P = vb_bem_eeg(D,Sout,Vhead,Fhead,V,J,Xeeg,BEM)
% EEG potential for multilayer model by BEM 
% ¿ض̥ǥΥݥƥ󥷥ȼ
%  P = vb_bem_eeg(D,Sout,Vhead,Fhead,V,J,Xeeg,BEM)
% OUTPUTS:
%  P : EEG Lead field matrix   ( Neeg x NP)
%  P : ¿إǥEEG 󥵥ݥƥ󥷥
%
% INPUTS (Required):
%   V   : dipole location(in meters)               NP x 3
%   J   : dipole moment                            NP x 3
%  Xeeg : EEG sensors(in meters) on the scalp      Neeg x 3
% D     : solid angle matrix for boundary surfaces
% Vhead : vertex coordinate for boundary surfaces
% Fhead : patch index for boundary surfaces
% Sout  : normal vector for boundary surfaces
%
% D     : ̷
% Vhead : ̤κɸ
% Fhead : ĺǥå
% Sout  : ̤γˡ
% V     : ήж˻Һɸ        (m)
% J     : ήж˻ҥ⡼  (A)
% Xeeg  : EEG 󥵺ɸ
%
% BEM.Nvertex   = ƶ̤ĺǥå
%               = [ start_id(1)     end_id(1)     ; 
%                             ...                 ;
%                   start_id(Nsurf) end_id(Nsurf) ]
%               = [ϥǥå, λǥå]
%                 innermost to outermost 
%
% BEM.Npatch	= ƶ̤λ̥ǥå 
%               = [ϥǥå, λǥå]
% BEM.sigma 	= ΰƳΨ 
%               = [sigma(1), ..., sigma(Nsurf), 0]
%
% 2004-12-26 M. Sato
% 2007-12-6  M. Sato 
%   EEG positions are mapped to outermost head surface first
% 2007-12-25  M. Sato 
%   EEG = Weighted average of potentials at nearest head positions
% 2008-10-8  M. Sato 
%   Multisurface correction & Auto solid angle calculation 
%   are done before saving omega
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%% ¿إǥ
%fprintf('--- Multisurface correction\n');
%[D, Keeg] = vb_bem_matrix(D,BEM);
%
%% ʽŤ߷ؿ򻰳̾ʬͿä
%fprintf('--- Auto solid angle calculation\n');
%D = vb_solid_auto_grk(D,Fhead,Sout);

% Inter-vertex distance of head surface
dnext = vb_next_vertex_distance(Fhead,Vhead);
dmax  = max(dnext);
dmean = mean(dnext);

fprintf('Mean inter-vertex distance of head surface = %f\n',dmean);
fprintf('MAX  inter-vertex distance of head surface = %f\n',dmax);

% EEG positions are mapped to outermost head surface
% IXeeg    : Vertex index nearest to EEG sensor [Neeg x Np]
% distance : Distance from EEG sensor to head vertex [Neeg x Np]
Np = 3; % number of close surface points for each sensor
[Xeeg, IXeeg, distance] = vb_map_eeg_to_head(Xeeg, Vhead, BEM, dmax, Np);

fprintf('Mean EEG-Vertex minimum distance = %f\n', mean(distance(:,1)));

% Extract valid vertex
ix_next = find( IXeeg > 0 );

fprintf('# of neighbor vertex for EEG = %d\n', length(ix_next))
fprintf('Mean EEG-Vertex distance = %f\n', mean(distance(ix_next)));

tic
% Peeg : ж˻ҥݥƥ󥷥뤫EEGݥƥ󥷥ؤѴ
fprintf('--- EEG transfer matrix calculation\n');
[Peeg] = vb_bem_inverse_eeg(D, IXeeg(ix_next), BEM);

vb_ptime(toc);
tic

% ݥƥ󥷥׻
fprintf('--- EEG potential calculation\n');
Phead = vb_bem_eeg_linear_grk(Peeg,Vhead,Fhead,V,J);

vb_ptime(toc);

% EEG = Weighted average of potentials at close head positions
%  Phead : head vertex potential  (Nhead x Ndipole)
%  P     : EEG Lead field matrix  ( Neeg x Ndipole)

fprintf('--- Interpolate head potential to EEG sensor position\n');

[Neeg, Np] = size(IXeeg); % Neeg = # of EEG sensor
NP = size(V,1); % # of dipoles
P  = zeros(Neeg,NP);

% Weight factor for average
Ptemp  = zeros(Neeg, Np);
weight = vb_linear_interpolate3(distance);

for n = 1:NP
	Ptemp(ix_next) = Phead(:,n);
	P(:,n) = sum(Ptemp .* weight , 2);
end
