function [F,V,xx,Ninfo] = vb_read_curry_surface(curryfile, analyzefile)
% Read surface data from Curry format file
%  [F,V,xx] = vb_read_curry_surface(curryfile, analyzefile)
%
% --- Input parameters
% curryfile
% analyzefile
% --- Output
% V  : vertex coordinate   : NV x 3 
% F  : surface patch index : NF x 3
% xx : normal vector       : NV x 3 
%
% CurryǺ줿ե(*.s00-s99)ɤ롣
% Curryεưstartup.cfgѹSAVE_PACKED
% 0ꤷƤȡ
% --- DEBUG info
%  [F,V,xx,Ninfo] = vb_read_curry_surface(curryfile, analyzefile)
% Ninfo : Debug info
%
% 2004-01-30 Taku Yoshioka
% 2004-02-12 Taku Yoshioka
% - ϰνѹ(Fˤʤ褦ˤ)
% 2005-07-06 Taku Yoshioka
% - SPM-ANALYZEɸϤǽϤ
% 2006-10-26 M.Sato
%  ANALYZEեΰ
%  vb_create_curry_patch ®
% 2007-06-25 M.Sato
%  Ǥդ礭βб뤿ANALYZEեΰ
% 2009-12-15 M.Sato
%  voxcel 1mmʳβб
%---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

fprintf('--- Read curry surface data \n');
fprintf('File = %s\n', curryfile);

if ~exist(curryfile,'file'), error('No curry file');end;

fp = fopen(curryfile,'r');

if fp < 0, error('Can not open file'), end;

%
% ĺ('LOCATION_LIST START'θξ)
%
while 1
  str = fgets(fp);
  if ~isempty(findstr(str,'LOCATION_LIST START'))
    while 1
      str = fgets(fp);
      if ~isempty(findstr(str,'LIST_NR_ROWS'))
		ix = findstr(str,'=');
		NV0 = str2num(str(ix+1:length(str)));
		fprintf('Number of faces: %d\n',NV0/3);
		break;
      end

      if feof(fp)
		error(['Entry ''LOCATION_LIST START'' is not closed.']);
      end
    end
  end
  
  if exist('NV0')
    break;
  end
  
  if feof(fp)
    error(['There is no entry ''LOCATION_LIST START'' ' ...
	   'in file ' curryfile '.']);
  end
end

disp('--- Read vertex position');

%
% ĺɸ('LOCATION_LIST START_LIST'ޤɤФ)
%
while 1
  str = fgets(fp);
  if ~isempty(findstr(str,'LOCATION_LIST START_LIST'))
    break;
  end

  if feof(fp)
    error(['There is no entry ''LOCATION_LIST START_LIST'' ' ...
	   'in file ' curryfile '.']);
  end
end

%
% --- Read Curry surface
%
FV = (fscanf(fp,'%u %u %u',[3 NV0]))';
fclose(fp);

%
% --- Create patch index from Curry vertex coordinate
%
tic;
[V,F,ix,Ninfo] = vb_create_curry_patch(FV);
vb_ptime(toc)

% ---  Debug
%fprintf('Npos=%d\n',size(FV,1))

if Ninfo.NFcnt ~= size(FV,1)
	fprintf('# of triangle vertex = %d\n',size(FV,1))
	fprintf('# of processed vertex\n',Ninfo.NFcnt)
	error('# of processed vertex is different')
end
if Ninfo.NVcnt ~= size(V,1)
	fprintf('# of vertex = %d\n',size(V,1))
	fprintf('# of processed vertex\n',Ninfo.NVcnt)
	error('# of processed vertex is different')
end

fprintf('# of vertex = %d\n',size(V,1))
fprintf('# of patch  = %d\n',size(F,1))

%
% ˡ(NORMALS_LIST)
%
disp('--- Read normal vector');
fp = fopen(curryfile,'r');

while 1
  str = fgets(fp);
  if ~isempty(findstr(str,'NORMALS_LIST START_LIST'))
    break;
  end

  if feof(fp)
    error(['There is no entry ''NORMALS_LIST START_LIST'' ' ...
	   'in file ' curryfile '.']);
  end
end

xx = (fscanf(fp,'%d %d %d',[3 NV0]))';
fclose(fp);

% outward normal direction 
xx = xx(ix,:);
xx = -1*xx./repmat(sqrt(sum(xx.^2,2)),[1 3]);

fprintf('# of normal = %d\n',size(xx,1))

%%%%% ---- DEBUG
%return
%%%%% ---- DEBUG

%
% --- Coordinate transformation from Curry to SPM-right
%

% --- Curry mm coordinate
% [Curry] 
% Xc:Right(1)->Left(256)
% Yc:Front(1)->Back(256)
% Zc:Bottom(1)->Top(256)
% --- SPM mm coordinate  
% Xs: Left(-NX/2)   -> Right(NX/2) 
% Ys: Back(-NY/2)   -> Front(NY/2)
% Zs: Bottom(-NZ/2) -> Top(NZ/2) 
% --- adjustment point : XY-centor & Z-Top
% RL-mid : Xc = 128 : Xs = 0 
% FB-mid : Yc = 128 : Ys = 0
% Top    : Zc = 256 : Zs = NZ/2
% ---
% Xs = - (Xc - NX/2)
% Ys = - (Yc - NY/2)
% Zs = Zc + NZ/2 - 256

[Vdim, Vsize] = analyze_hdr_read(analyzefile);

X0 = 128;
Y0 = 128;
Z0 = 256;

% adjust Curry origin
V(:,1) = V(:,1) - X0;
V(:,2) = V(:,2) - Y0;
V(:,3) = V(:,3) - Z0;

% scale transformation to mm
scale  = Vsize(2);
%scale  = min(Vsize);

V  = scale*V;

% adjust SPM origin
X0 = 0;
Y0 = 0;
Z0 = Vdim(3)*Vsize(3)/2;

% Curry mm to SPM mm coordinate
V(:,1) = X0 - V(:,1);
V(:,2) = Y0 - V(:,2);
V(:,3) = Z0 + V(:,3);

xx(:,1) = -xx(:,1);
xx(:,2) = -xx(:,2);
xx(:,3) =  xx(:,3);

V  = V./1000;	% mm -> m

solid_angle  = vb_solid_angle_check(V,F);

fprintf('Closed surface index = %f ( = 1)\n',solid_angle);
