function vb_dicom2curry(infile_pref,outfile_pref,flag)
% function vb_dicom2curry(infile_pref,outfile_pref,flag)
%
% DICOMǡCurryѤѴ
% 2004-01-31 Taku Yoshioka
%
% ϡDICOM饤
% ϡCurryѥե(.imd,եޤǥ쥯ȥ)
%
% infile_pref: 
% 饤Υץեåinfile_pref1鳫Ϥ
% ֹդեɤ߹ࡣinfile_prefˤϥѥ졼
% (._ʤ)ޤ뤳ȡ'.mri''.dcm'äե뤬
% ¸ߤСͥ褷ɤ߹ࡣ
%
% out_pref: 
% ϥե̾إåե[outfile_pref].imdȡǡ
% [outfile_pref].img롣
%
% flag: 
% 'header'ꤹȡimdեΤߺ롣
%
% ɸ
% 
% DICOMե뤫ɤ߹
% slice_thickness
% rows
% columns
% bits_allocated
% high_bit
%
% Ѥ٤Ȼפ뤬̣ʬʤѥ᡼
% pixel_spacing(ԥμ¥)
% image_position()
% image_orientation(᡼θ)
%
% 
% 饤θSagitalΤбƤ
% 饤ʳ2ˤĤơԥμ¥1mmȲ
%
% 2011-06-20 taku-y
%  [minor] Progress message was added. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% եå
%
infile_suf = '';
if exist([infile_pref '1.mri'])
  infile_suf = '.mri';
elseif exist([infile_pref '1.dcm'])
  infile_suf = '.dcm';
end

disp(['prefix: ' infile_pref]);
disp(['sufix : ' infile_suf]);

%
% ΥȤȺ綯٤
%
fprintf('\n');
fprintf('--- Count num. of images ');

Nimg = 1;
v_max = 0;

while 1
  if ~exist([infile_pref num2str(Nimg) infile_suf])
    Nimg = Nimg-1;
    break;
  end
  s = read_dicom([infile_pref num2str(Nimg) infile_suf]);
  v_max = max([v_max; s.pixel_data(:)]);
  clear s;
  
  Nimg = Nimg+1;
  
  if mod(Nimg,10) == 0
    fprintf('-');
  end
end

fprintf(' %d files \n',Nimg);

%
% إåե
%
fprintf('--- Create header file\n');

s = read_dicom([infile_pref '1' infile_suf]);

fp = fopen([outfile_pref '.imd'],'w');
fprintf(fp,'IMAGE_KEYWORDS START\n');
fprintf(fp,'\tSLICE_DISTANCE\t= %f\n',s.slice_thickness);
fprintf(fp,'\tSLICE_NR\t= %d\n',Nimg);
fprintf(fp,'\tSLICE_VALID\t= %d\n',Nimg);
fprintf(fp,'\tSLICE_NR1ST\t= 1\n');
fprintf(fp,'\tRAW_IMAGE_FORMAT\t= 2\n');
fprintf(fp,'\tRAW_NUMBER_OF_BITS\t= %d\n',s.bits_allocated);
fprintf(fp,'\tRAW_MOST_SIGN_BIT\t= %d\n',s.high_bit);
fprintf(fp,'\tRAW_OFFSET\t= 0\n');
fprintf(fp,'\tRAW_PIXEL_SIZE_X\t= 1\n');
fprintf(fp,'\tRAW_PIXEL_SIZE_Y\t= 1\n');
fprintf(fp,'\tRAW_SIZE_X\t= %d\n',double(s.rows));
fprintf(fp,'\tRAW_SIZE_Y\t= %d\n',double(s.columns));
fprintf(fp,'\tSLICE_ORDER\t= 1\n');
fprintf(fp,'IMAGE_KEYWORDS END');
fclose(fp);

%
% DICOM᡼ɤ߹ߡޤȤƥե¸
%
if nargin == 3 & strcmp(flag,'header')
  return;
else
  fprintf(['--- Save image data (' outfile_pref '.img)\n']);

  Z = 65535/v_max;
  fp = fopen([outfile_pref '.img'],'w');

  h = waitbar(0,'Save Curry image data');
  prg = 0;
  prg_all = Nimg;
  vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));
  
  for i = 1:Nimg
    s = read_dicom([infile_pref num2str(i) infile_suf]);
  
    % ǡν񤭹
    fwrite(fp,(s.pixel_data.*Z)','uint16');
    clear s;
  
    if mod(i,10) == 0
      waitbar(i/Nimg);
      for ii=1:15; vb_disp_nonl(sprintf('\b')); end
      vb_disp_nonl(sprintf('%3d %% processed',ceil(100*(prg/prg_all))));
    end
    prg = prg+1;
  end

  fclose(fp);
  close(h);
  drawnow;
  vb_disp_nonl(sprintf('\n'));
end

return;